/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.membership.DeleteMembershipCommand;
import io.gravitee.cockpit.api.command.v1.membership.DeleteMembershipCommandPayload;
import io.gravitee.cockpit.api.command.v1.membership.DeleteMembershipReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.reactivex.rxjava3.core.Single;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeleteMembershipCommandHandler
implements CommandHandler<DeleteMembershipCommand, DeleteMembershipReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteMembershipCommandHandler.class);
    private final MembershipService membershipService;
    private final UserService userService;

    public String supportType() {
        return CockpitCommandType.DELETE_MEMBERSHIP.name();
    }

    public Single<DeleteMembershipReply> handle(DeleteMembershipCommand command) {
        DeleteMembershipCommandPayload membershipPayload = (DeleteMembershipCommandPayload)command.getPayload();
        try {
            MembershipReferenceType membershipReferenceType;
            try {
                membershipReferenceType = MembershipReferenceType.valueOf((String)membershipPayload.referenceType());
            }
            catch (Exception e) {
                String errorDetails = "Invalid referenceType [%s].".formatted(membershipPayload.referenceType());
                log.error(errorDetails, (Throwable)e);
                return Single.just((Object)new DeleteMembershipReply(command.getId(), errorDetails));
            }
            ExecutionContext executionContext = new ExecutionContext(membershipPayload.organizationId(), membershipReferenceType.equals((Object)MembershipReferenceType.ENVIRONMENT) ? membershipPayload.referenceId() : null);
            UserEntity userEntity = this.userService.findBySource(executionContext.getOrganizationId(), "cockpit", membershipPayload.userId(), false);
            this.membershipService.deleteReferenceMember(executionContext, membershipReferenceType, membershipPayload.referenceId(), MembershipMemberType.USER, userEntity.getId());
            log.info("Delete reference member with organization [{}] referenceType [{}] referenceId [{}] and memberId [{}]", new Object[]{membershipPayload.organizationId(), membershipPayload.referenceType(), membershipPayload.referenceId(), membershipPayload.userId()});
            return Single.just((Object)new DeleteMembershipReply(command.getId()));
        }
        catch (Exception e) {
            String errorDetails = "Error occurred when trying to delete member on %s [%s] for cockpit user [%s] and organization [%s].".formatted(membershipPayload.referenceType(), membershipPayload.referenceId(), membershipPayload.userId(), membershipPayload.organizationId());
            log.error(errorDetails, (Throwable)e);
            return Single.just((Object)new DeleteMembershipReply(command.getId(), errorDetails));
        }
    }

    @Generated
    public DeleteMembershipCommandHandler(MembershipService membershipService, UserService userService) {
        this.membershipService = membershipService;
        this.userService = userService;
    }
}

