/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.domain_service.GroupValidationService;
import io.gravitee.apim.core.api.domain_service.ValidateApiLifecycleService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.definition.model.DefinitionVersion;
import java.util.Set;
import lombok.Generated;

@DomainService
public class ValidateFederatedApiDomainService {
    private final GroupValidationService groupValidationService;

    public Api validateAndSanitizeForCreation(Api api) {
        if (api.getDefinitionVersion() != DefinitionVersion.FEDERATED) {
            throw new ValidationDomainException("Definition version is unsupported, should be FEDERATED");
        }
        api.setLifecycleState(null);
        return api;
    }

    public Api validateAndSanitizeForUpdate(Api updateApi, Api existingApi, PrimaryOwnerEntity primaryOwnerEntity) {
        Set<String> groupIds = this.groupValidationService.validateAndSanitize(updateApi.getGroups(), existingApi.getEnvironmentId(), primaryOwnerEntity);
        updateApi.setGroups(groupIds);
        Api.ApiLifecycleState lifecycleState = ValidateApiLifecycleService.validateFederatedApiLifecycleState(existingApi.getApiLifecycleState(), updateApi.getApiLifecycleState());
        updateApi.setApiLifecycleState(lifecycleState);
        return updateApi;
    }

    @Generated
    public ValidateFederatedApiDomainService(GroupValidationService groupValidationService) {
        this.groupValidationService = groupValidationService;
    }
}

