/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.rest.api.service.exceptions.LifecycleStateChangeNotAllowedException;

public class ValidateApiLifecycleService {
    public static Api.ApiLifecycleState validateFederatedApiLifecycleState(Api.ApiLifecycleState existingLifecycleState, Api.ApiLifecycleState newLifecycleState) {
        if (newLifecycleState == null) {
            return existingLifecycleState;
        }
        if (Api.ApiLifecycleState.DEPRECATED == existingLifecycleState) {
            throw new LifecycleStateChangeNotAllowedException(newLifecycleState.name());
        }
        if (Api.ApiLifecycleState.ARCHIVED == existingLifecycleState) {
            throw new LifecycleStateChangeNotAllowedException(newLifecycleState.name());
        }
        if (existingLifecycleState == newLifecycleState) {
            return existingLifecycleState;
        }
        if (Api.ApiLifecycleState.UNPUBLISHED == existingLifecycleState && Api.ApiLifecycleState.CREATED == newLifecycleState) {
            throw new LifecycleStateChangeNotAllowedException(newLifecycleState.name());
        }
        return newLifecycleState;
    }
}

