/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.query_service.IntegrationQueryService;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class GetIntegrationsUseCase {
    private final IntegrationQueryService integrationQueryService;
    private final LicenseDomainService licenseDomainService;

    public GetIntegrationsUseCase(IntegrationQueryService integrationQueryService, LicenseDomainService licenseDomainService) {
        this.integrationQueryService = integrationQueryService;
        this.licenseDomainService = licenseDomainService;
    }

    public Output execute(Input input) {
        String environmentId = input.environmentId();
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 10));
        if (!this.licenseDomainService.isFederationFeatureAllowed(input.organizationId())) {
            throw NotAllowedDomainException.noLicenseForFederation();
        }
        Page<Integration> integrations = this.integrationQueryService.findByEnvironment(environmentId, pageable);
        return new Output(integrations);
    }

    public record Input(String organizationId, String environmentId, Optional<Pageable> pageable) {
        public Input(String organizationId, String environmentId) {
            this(organizationId, environmentId, Optional.empty());
        }

        public Input(String organizationId, String environmentId, Pageable pageable) {
            this(organizationId, environmentId, Optional.of(pageable));
        }

        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String organizationId;
            @Generated
            private String environmentId;
            @Generated
            private Optional<Pageable> pageable;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder organizationId(String organizationId) {
                this.organizationId = organizationId;
                return this;
            }

            @Generated
            public InputBuilder environmentId(String environmentId) {
                this.environmentId = environmentId;
                return this;
            }

            @Generated
            public InputBuilder pageable(Optional<Pageable> pageable) {
                this.pageable = pageable;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.organizationId, this.environmentId, this.pageable);
            }

            @Generated
            public String toString() {
                return "GetIntegrationsUseCase.Input.InputBuilder(organizationId=" + this.organizationId + ", environmentId=" + this.environmentId + ", pageable=" + this.pageable + ")";
            }
        }
    }

    public record Output(Page<Integration> integrations) {
    }
}

