/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.category.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.domain_service.ApiAuthorizationDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiQueryCriteria;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.category.domain_service.ValidateCategoryDomainService;
import io.gravitee.apim.core.category.model.ApiCategoryOrder;
import io.gravitee.apim.core.category.query_service.ApiCategoryOrderQueryService;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@UseCase
public class GetCategoryApisUseCase {
    private final ValidateCategoryDomainService validateCategoryDomainService;
    private final ApiAuthorizationDomainService apiAuthorizationDomainService;
    private final ApiCategoryOrderQueryService apiCategoryOrderQueryService;
    private final ApiQueryService apiQueryService;

    public Output execute(Input input) {
        String categoryId = this.validateAndGetCategoryId(input.categoryIdOrKey(), input.executionContext().getEnvironmentId());
        Set<ApiCategoryOrder> apiCategoryOrders = this.apiCategoryOrderQueryService.findAllByCategoryId(categoryId);
        if (apiCategoryOrders.isEmpty()) {
            return new Output(List.of());
        }
        List<String> apiCategoryOrderApiIds = GetCategoryApisUseCase.extractApiIds(apiCategoryOrders);
        List<Api> apis = this.getUserApisByCategoryAndApis(input.executionContext(), input.isAdmin(), input.onlyPublishedApiLifecycleState(), input.currentUserId(), categoryId, apiCategoryOrderApiIds).toList();
        List<Result> results = GetCategoryApisUseCase.mapToResult(apis, apiCategoryOrders).sorted(Comparator.comparingInt(o -> o.apiCategoryOrder.getOrder())).toList();
        return new Output(results);
    }

    private static Stream<Result> mapToResult(List<Api> apis, Set<ApiCategoryOrder> apiCategoryOrders) {
        Map apiCategoryOrderByApi = apiCategoryOrders.stream().collect(Collectors.toMap(ApiCategoryOrder::getApiId, Function.identity()));
        return apis.stream().map(api -> Optional.ofNullable((ApiCategoryOrder)apiCategoryOrderByApi.get(api.getId())).map(apiCategoryOrder -> new Result((ApiCategoryOrder)apiCategoryOrder, (Api)api)).orElse(null)).filter(Objects::nonNull);
    }

    private Stream<Api> getUserApisByCategoryAndApis(ExecutionContext executionContext, boolean isAdmin, boolean onlyPublishedApiLifecycleState, String userId, String categoryId, List<String> apiIds) {
        ApiSearchCriteria.ApiSearchCriteriaBuilder apiSearchCriteria = ApiSearchCriteria.builder().category(categoryId);
        if (onlyPublishedApiLifecycleState) {
            apiSearchCriteria.lifecycleStates(List.of(Api.ApiLifecycleState.PUBLISHED));
        }
        if (isAdmin) {
            apiSearchCriteria.ids(apiIds);
        } else {
            ApiQueryCriteria.ApiQueryCriteriaBuilder apiQueryCriteria = ApiQueryCriteria.builder().ids(apiIds).category(categoryId);
            if (onlyPublishedApiLifecycleState) {
                apiQueryCriteria.lifecycleStates(List.of(ApiLifecycleState.PUBLISHED));
            }
            Set<String> apiIdsInUserScope = this.apiAuthorizationDomainService.findIdsByUser(executionContext, userId, apiQueryCriteria.build(), null, false);
            apiSearchCriteria.ids(new ArrayList<String>(apiIdsInUserScope));
        }
        return this.apiQueryService.search(apiSearchCriteria.build(), null, ApiFieldFilter.builder().pictureExcluded(true).build());
    }

    private static List<String> extractApiIds(Set<ApiCategoryOrder> apiCategoryOrders) {
        return apiCategoryOrders.stream().map(ApiCategoryOrder::getApiId).toList();
    }

    private String validateAndGetCategoryId(String categoryIdOrKey, String environmentId) {
        return this.validateCategoryDomainService.validateCategoryIdOrKey(categoryIdOrKey, environmentId);
    }

    @Generated
    public GetCategoryApisUseCase(ValidateCategoryDomainService validateCategoryDomainService, ApiAuthorizationDomainService apiAuthorizationDomainService, ApiCategoryOrderQueryService apiCategoryOrderQueryService, ApiQueryService apiQueryService) {
        this.validateCategoryDomainService = validateCategoryDomainService;
        this.apiAuthorizationDomainService = apiAuthorizationDomainService;
        this.apiCategoryOrderQueryService = apiCategoryOrderQueryService;
        this.apiQueryService = apiQueryService;
    }

    public record Input(ExecutionContext executionContext, String categoryIdOrKey, String currentUserId, boolean isAdmin, boolean onlyPublishedApiLifecycleState) {
        public Input(ExecutionContext executionContext, String categoryIdOrKey, String currentUserId, boolean isAdmin) {
            this(executionContext, categoryIdOrKey, currentUserId, isAdmin, false);
        }
    }

    public record Output(List<Result> results) {
    }

    public record Result(ApiCategoryOrder apiCategoryOrder, Api api) {
    }
}

