/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.TicketRepository;
import io.gravitee.repository.management.api.search.Order;
import io.gravitee.repository.management.api.search.Sortable;
import io.gravitee.repository.management.api.search.TicketCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.api.search.builder.SortableBuilder;
import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.repository.management.model.Ticket;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.MetadataEntity;
import io.gravitee.rest.api.model.NewTicketEntity;
import io.gravitee.rest.api.model.TicketEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.TicketQuery;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiModel;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.MetadataService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.TicketService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.EmailRequiredException;
import io.gravitee.rest.api.service.exceptions.SupportUnavailableException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.TicketNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.ApplicationHook;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import io.gravitee.rest.api.service.notification.PortalHook;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.ApiTemplateService;
import jakarta.inject.Inject;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TicketServiceImpl
extends AbstractService
implements TicketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketServiceImpl.class);
    private static final String UNKNOWN_REFERENCE = "Unknown";
    @Inject
    private UserService userService;
    @Inject
    private MetadataService metadataService;
    @Inject
    private ApiSearchService apiSearchService;
    @Inject
    private ApiTemplateService apiTemplateService;
    @Inject
    private ApplicationService applicationService;
    @Inject
    private EmailService emailService;
    @Inject
    private ParameterService parameterService;
    @Inject
    private NotifierService notifierService;
    @Lazy
    @Inject
    private TicketRepository ticketRepository;

    private boolean isEnabled(ExecutionContext executionContext, String referenceId, ParameterReferenceType referenceType) {
        if (referenceType == ParameterReferenceType.ENVIRONMENT) {
            return this.parameterService.findAsBoolean(executionContext, Key.PORTAL_SUPPORT_ENABLED, referenceId, referenceType);
        }
        return this.parameterService.findAsBoolean(executionContext, Key.CONSOLE_SUPPORT_ENABLED, referenceId, referenceType);
    }

    @Override
    public TicketEntity create(ExecutionContext executionContext, String userId, NewTicketEntity ticketEntity, String referenceId, ParameterReferenceType referenceType) {
        try {
            ApplicationEntity applicationEntity;
            String emailTo;
            GenericApiModel api;
            if (!this.isEnabled(executionContext, referenceId, referenceType)) {
                throw new SupportUnavailableException();
            }
            LOGGER.info("Creating a support ticket: {}", (Object)ticketEntity);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            UserEntity user = this.userService.findById(executionContext, userId);
            if (user.getEmail() == null) {
                throw new EmailRequiredException(userId);
            }
            parameters.put("user", user);
            if (ticketEntity.getApi() == null || ticketEntity.getApi().isEmpty()) {
                api = null;
                MetadataEntity emailMetadata = this.metadataService.findByKeyAndReferenceTypeAndReferenceId("email-support", MetadataReferenceType.ENVIRONMENT, executionContext.getEnvironmentId());
                if (emailMetadata == null) {
                    throw new IllegalStateException("The support email metadata has not been found");
                }
                emailTo = emailMetadata.getValue();
            } else {
                api = this.apiTemplateService.findByIdForTemplates(executionContext, ticketEntity.getApi(), true);
                String apiMetadataEmailSupport = (String)api.getMetadata().get("email-support");
                if (apiMetadataEmailSupport == null) {
                    throw new IllegalStateException("The support email API metadata has not been found");
                }
                emailTo = apiMetadataEmailSupport;
                parameters.put("api", api);
            }
            if ("support@change.me".equals(emailTo)) {
                throw new IllegalStateException("The support email API metadata has not been changed");
            }
            if (ticketEntity.getApplication() != null && !ticketEntity.getApplication().isEmpty()) {
                applicationEntity = this.applicationService.findById(executionContext, ticketEntity.getApplication());
                parameters.put("application", applicationEntity);
            } else {
                applicationEntity = null;
            }
            parameters.put("content", ticketEntity.getContent().replaceAll("(\r\n|\n)", "<br />"));
            parameters.put("ticketSubject", ticketEntity.getSubject());
            String fromName = user.getFirstname() == null ? user.getEmail() : user.getFirstname() + " " + user.getLastname();
            this.emailService.sendEmailNotification(executionContext, new EmailNotificationBuilder().replyTo(user.getEmail()).fromName(fromName).to(emailTo).copyToSender(ticketEntity.isCopyToSender()).template(EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_SUPPORT_TICKET).params(parameters).build());
            this.sendUserNotification(executionContext, user, api, applicationEntity);
            Ticket ticket = this.convert(ticketEntity);
            ticket.setId(UuidString.generateRandom());
            ticket.setCreatedAt(new Date());
            ticket.setFromUser(userId);
            Ticket createdTicket = this.ticketRepository.create(ticket);
            return this.convert(createdTicket);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to create a ticket {}", (Object)ticketEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create a ticket " + ticketEntity, ex);
        }
    }

    @Override
    public Page<TicketEntity> search(ExecutionContext executionContext, TicketQuery query, io.gravitee.rest.api.model.common.Sortable sortable, Pageable pageable) {
        try {
            LOGGER.debug("search tickets");
            TicketCriteria criteria = this.queryToCriteriaBuilder(query).build();
            Page tickets = this.ticketRepository.search(criteria, this.buildSortable(sortable), new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build());
            List entities = tickets.getContent().stream().map(ticket -> this.getApiNameAndApplicationName(executionContext, (Ticket)ticket)).map(this::convert).collect(Collectors.toList());
            LOGGER.debug("search tickets - Done with {} elements", (Object)entities.size());
            return new Page(entities, tickets.getPageNumber() + 1, (int)tickets.getPageElements(), tickets.getTotalElements());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to search tickets", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search tickets", ex);
        }
    }

    @Override
    public TicketEntity findById(ExecutionContext executionContext, String ticketId) {
        try {
            return this.ticketRepository.findById(ticketId).filter(t -> t.getFromUser().equalsIgnoreCase(this.getAuthenticatedUsername())).map(ticket -> this.getApiNameAndApplicationName(executionContext, (Ticket)ticket)).map(this::convert).orElseThrow(() -> new TicketNotFoundException(ticketId));
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to search ticket {}", (Object)ticketId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to search ticket " + ticketId, ex);
        }
    }

    private void sendUserNotification(ExecutionContext executionContext, UserEntity user, GenericApiModel genericApiModel, ApplicationEntity application) {
        this.notifierService.trigger(executionContext, PortalHook.NEW_SUPPORT_TICKET, new NotificationParamsBuilder().user(user).api(genericApiModel).application(application).build());
        if (genericApiModel != null) {
            this.notifierService.trigger(executionContext, ApiHook.NEW_SUPPORT_TICKET, genericApiModel.getId(), new NotificationParamsBuilder().user(user).api(genericApiModel).application(application).build());
        }
        if (application != null) {
            this.notifierService.trigger(executionContext, ApplicationHook.NEW_SUPPORT_TICKET, application.getId(), new NotificationParamsBuilder().user(user).api(genericApiModel).application(application).build());
        }
    }

    private TicketEntity convert(Ticket ticket) {
        if (ticket == null) {
            return null;
        }
        TicketEntity ticketEntity = new TicketEntity();
        ticketEntity.setId(ticket.getId());
        ticketEntity.setApi(ticket.getApi());
        ticketEntity.setApplication(ticket.getApplication());
        ticketEntity.setSubject(ticket.getSubject());
        ticketEntity.setContent(ticket.getContent());
        ticketEntity.setCreatedAt(ticket.getCreatedAt());
        ticketEntity.setFromUser(ticket.getFromUser());
        return ticketEntity;
    }

    private Ticket convert(NewTicketEntity ticketEntity) {
        if (ticketEntity == null) {
            return null;
        }
        Ticket ticket = new Ticket();
        ticket.setApi(ticketEntity.getApi());
        ticket.setApplication(ticketEntity.getApplication());
        ticket.setSubject(ticketEntity.getSubject());
        ticket.setContent(ticketEntity.getContent());
        return ticket;
    }

    private Ticket getApiNameAndApplicationName(ExecutionContext executionContext, Ticket ticket) {
        if (StringUtils.isNotEmpty((CharSequence)ticket.getApplication())) {
            try {
                ApplicationEntity application = this.applicationService.findById(executionContext, ticket.getApplication());
                ticket.setApplication(application.getName());
            }
            catch (ApplicationNotFoundException e) {
                ticket.setApplication(UNKNOWN_REFERENCE);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)ticket.getApi())) {
            try {
                GenericApiEntity api = this.apiSearchService.findGenericById(executionContext, ticket.getApi());
                ticket.setApi(api.getName());
            }
            catch (ApiNotFoundException e) {
                ticket.setApi(UNKNOWN_REFERENCE);
            }
        }
        return ticket;
    }

    private TicketCriteria.Builder queryToCriteriaBuilder(TicketQuery query) {
        TicketCriteria.Builder builder = new TicketCriteria.Builder().fromUser(query.getFromUser());
        if (!StringUtils.isBlank((CharSequence)query.getApi())) {
            builder.api(query.getApi());
        }
        if (!StringUtils.isBlank((CharSequence)query.getApplication())) {
            builder.application(query.getApplication());
        }
        return builder;
    }

    private Sortable buildSortable(io.gravitee.rest.api.model.common.Sortable sortable) {
        if (sortable == null) {
            return null;
        }
        return new SortableBuilder().field(sortable.getField()).order(sortable.isAscOrder() ? Order.ASC : Order.DESC).build();
    }
}

