/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.membership;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.membership.query_service.RoleQueryService;
import io.gravitee.apim.infra.adapter.RoleAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.rest.api.service.common.ReferenceContext;
import java.util.Optional;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class RoleQueryServiceImpl
implements RoleQueryService {
    private final RoleRepository roleRepository;

    public RoleQueryServiceImpl(@Lazy RoleRepository roleRepository) {
        this.roleRepository = roleRepository;
    }

    @Override
    public Optional<Role> findApiRole(String name, ReferenceContext referenceContext) {
        try {
            return this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.API, name, referenceContext.getReferenceId(), RoleReferenceType.valueOf((String)referenceContext.getReferenceType().name())).map(RoleAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to find api role", e);
        }
    }

    @Override
    public Optional<Role> findApplicationRole(String name, ReferenceContext referenceContext) {
        try {
            return this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.APPLICATION, name, referenceContext.getReferenceId(), RoleReferenceType.valueOf((String)referenceContext.getReferenceType().name())).map(RoleAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to find application role", e);
        }
    }
}

