/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.subscription.model;

import io.gravitee.apim.core.subscription.model.SubscriptionConfiguration;
import io.gravitee.common.utils.TimeProvider;
import java.time.ZonedDateTime;
import java.util.Map;
import lombok.Generated;

public class SubscriptionEntity {
    private String id;
    private String apiId;
    private String environmentId;
    private String planId;
    private String applicationId;
    private String clientId;
    private ZonedDateTime processedAt;
    private String requestMessage;
    private String reasonMessage;
    private Status status;
    private ConsumerStatus consumerStatus;
    private String processedBy;
    private String subscribedBy;
    private ZonedDateTime startingAt;
    private ZonedDateTime endingAt;
    private ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;
    private ZonedDateTime closedAt;
    private ZonedDateTime pausedAt;
    private ZonedDateTime consumerPausedAt;
    private Integer generalConditionsContentRevision;
    private String generalConditionsContentPageId;
    private Boolean generalConditionsAccepted;
    private Integer daysToExpirationOnLastNotification;
    private SubscriptionConfiguration configuration;
    private Map<String, String> metadata;
    private Type type;
    private String failureCause;

    public boolean canBeStartedByConsumer() {
        return ConsumerStatus.STOPPED.equals((Object)this.consumerStatus) || ConsumerStatus.FAILURE.equals((Object)this.consumerStatus);
    }

    public boolean canBeStoppedByConsumer() {
        return ConsumerStatus.STARTED.equals((Object)this.consumerStatus) || ConsumerStatus.FAILURE.equals((Object)this.consumerStatus);
    }

    public SubscriptionEntity close() {
        return switch (this.status) {
            default -> throw new IncompatibleClassChangeError();
            case Status.ACCEPTED, Status.PAUSED -> {
                ZonedDateTime now = ZonedDateTime.now();
                yield this.toBuilder().updatedAt(now).closedAt(now).status(Status.CLOSED).build();
            }
            case Status.REJECTED, Status.CLOSED -> this;
            case Status.PENDING -> throw new IllegalStateException("Pending subscription is not closable");
        };
    }

    public SubscriptionEntity rejectBy(String userId, String reason) {
        if (Status.PENDING.equals((Object)this.status)) {
            ZonedDateTime now = TimeProvider.now();
            return this.toBuilder().processedBy(userId).processedAt(now).updatedAt(now).closedAt(now).status(Status.REJECTED).reasonMessage(reason).build();
        }
        throw new IllegalStateException("Cannot reject subscription");
    }

    public SubscriptionEntity acceptBy(String userId, ZonedDateTime startingAt, ZonedDateTime endingAt, String reasonMessage) {
        return this.acceptBy(userId, startingAt, endingAt, reasonMessage, null);
    }

    public SubscriptionEntity acceptBy(String userId, ZonedDateTime startingAt, ZonedDateTime endingAt, String reasonMessage, Map<String, String> metadata) {
        return switch (this.status) {
            case Status.PENDING -> {
                ZonedDateTime now = TimeProvider.now();
                yield this.toBuilder().processedBy(userId).updatedAt(now).startingAt(startingAt != null ? startingAt : now).endingAt(endingAt).processedAt(now).status(Status.ACCEPTED).reasonMessage(reasonMessage).metadata(metadata).build();
            }
            case Status.ACCEPTED -> this;
            default -> throw new IllegalStateException("Cannot accept subscription");
        };
    }

    public boolean isAccepted() {
        return this.status == Status.ACCEPTED;
    }

    public boolean isPaused() {
        return this.status == Status.PAUSED;
    }

    public boolean isPending() {
        return this.status == Status.PENDING;
    }

    public boolean isRejected() {
        return this.status == Status.REJECTED;
    }

    public boolean isClosed() {
        return this.status == Status.CLOSED;
    }

    @Generated
    private static ConsumerStatus $default$consumerStatus() {
        return ConsumerStatus.STARTED;
    }

    @Generated
    private static Type $default$type() {
        return Type.STANDARD;
    }

    @Generated
    public static SubscriptionEntityBuilder builder() {
        return new SubscriptionEntityBuilder();
    }

    @Generated
    public SubscriptionEntityBuilder toBuilder() {
        return new SubscriptionEntityBuilder().id(this.id).apiId(this.apiId).environmentId(this.environmentId).planId(this.planId).applicationId(this.applicationId).clientId(this.clientId).processedAt(this.processedAt).requestMessage(this.requestMessage).reasonMessage(this.reasonMessage).status(this.status).consumerStatus(this.consumerStatus).processedBy(this.processedBy).subscribedBy(this.subscribedBy).startingAt(this.startingAt).endingAt(this.endingAt).createdAt(this.createdAt).updatedAt(this.updatedAt).closedAt(this.closedAt).pausedAt(this.pausedAt).consumerPausedAt(this.consumerPausedAt).generalConditionsContentRevision(this.generalConditionsContentRevision).generalConditionsContentPageId(this.generalConditionsContentPageId).generalConditionsAccepted(this.generalConditionsAccepted).daysToExpirationOnLastNotification(this.daysToExpirationOnLastNotification).configuration(this.configuration).metadata(this.metadata).type(this.type).failureCause(this.failureCause);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getApiId() {
        return this.apiId;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public String getPlanId() {
        return this.planId;
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public ZonedDateTime getProcessedAt() {
        return this.processedAt;
    }

    @Generated
    public String getRequestMessage() {
        return this.requestMessage;
    }

    @Generated
    public String getReasonMessage() {
        return this.reasonMessage;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public ConsumerStatus getConsumerStatus() {
        return this.consumerStatus;
    }

    @Generated
    public String getProcessedBy() {
        return this.processedBy;
    }

    @Generated
    public String getSubscribedBy() {
        return this.subscribedBy;
    }

    @Generated
    public ZonedDateTime getStartingAt() {
        return this.startingAt;
    }

    @Generated
    public ZonedDateTime getEndingAt() {
        return this.endingAt;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public ZonedDateTime getClosedAt() {
        return this.closedAt;
    }

    @Generated
    public ZonedDateTime getPausedAt() {
        return this.pausedAt;
    }

    @Generated
    public ZonedDateTime getConsumerPausedAt() {
        return this.consumerPausedAt;
    }

    @Generated
    public Integer getGeneralConditionsContentRevision() {
        return this.generalConditionsContentRevision;
    }

    @Generated
    public String getGeneralConditionsContentPageId() {
        return this.generalConditionsContentPageId;
    }

    @Generated
    public Boolean getGeneralConditionsAccepted() {
        return this.generalConditionsAccepted;
    }

    @Generated
    public Integer getDaysToExpirationOnLastNotification() {
        return this.daysToExpirationOnLastNotification;
    }

    @Generated
    public SubscriptionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public String getFailureCause() {
        return this.failureCause;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setPlanId(String planId) {
        this.planId = planId;
    }

    @Generated
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setProcessedAt(ZonedDateTime processedAt) {
        this.processedAt = processedAt;
    }

    @Generated
    public void setRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
    }

    @Generated
    public void setReasonMessage(String reasonMessage) {
        this.reasonMessage = reasonMessage;
    }

    @Generated
    public void setStatus(Status status) {
        this.status = status;
    }

    @Generated
    public void setConsumerStatus(ConsumerStatus consumerStatus) {
        this.consumerStatus = consumerStatus;
    }

    @Generated
    public void setProcessedBy(String processedBy) {
        this.processedBy = processedBy;
    }

    @Generated
    public void setSubscribedBy(String subscribedBy) {
        this.subscribedBy = subscribedBy;
    }

    @Generated
    public void setStartingAt(ZonedDateTime startingAt) {
        this.startingAt = startingAt;
    }

    @Generated
    public void setEndingAt(ZonedDateTime endingAt) {
        this.endingAt = endingAt;
    }

    @Generated
    public void setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(ZonedDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setClosedAt(ZonedDateTime closedAt) {
        this.closedAt = closedAt;
    }

    @Generated
    public void setPausedAt(ZonedDateTime pausedAt) {
        this.pausedAt = pausedAt;
    }

    @Generated
    public void setConsumerPausedAt(ZonedDateTime consumerPausedAt) {
        this.consumerPausedAt = consumerPausedAt;
    }

    @Generated
    public void setGeneralConditionsContentRevision(Integer generalConditionsContentRevision) {
        this.generalConditionsContentRevision = generalConditionsContentRevision;
    }

    @Generated
    public void setGeneralConditionsContentPageId(String generalConditionsContentPageId) {
        this.generalConditionsContentPageId = generalConditionsContentPageId;
    }

    @Generated
    public void setGeneralConditionsAccepted(Boolean generalConditionsAccepted) {
        this.generalConditionsAccepted = generalConditionsAccepted;
    }

    @Generated
    public void setDaysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    @Generated
    public void setConfiguration(SubscriptionConfiguration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setType(Type type) {
        this.type = type;
    }

    @Generated
    public void setFailureCause(String failureCause) {
        this.failureCause = failureCause;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionEntity)) {
            return false;
        }
        SubscriptionEntity other = (SubscriptionEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$generalConditionsContentRevision = this.getGeneralConditionsContentRevision();
        Integer other$generalConditionsContentRevision = other.getGeneralConditionsContentRevision();
        if (this$generalConditionsContentRevision == null ? other$generalConditionsContentRevision != null : !((Object)this$generalConditionsContentRevision).equals(other$generalConditionsContentRevision)) {
            return false;
        }
        Boolean this$generalConditionsAccepted = this.getGeneralConditionsAccepted();
        Boolean other$generalConditionsAccepted = other.getGeneralConditionsAccepted();
        if (this$generalConditionsAccepted == null ? other$generalConditionsAccepted != null : !((Object)this$generalConditionsAccepted).equals(other$generalConditionsAccepted)) {
            return false;
        }
        Integer this$daysToExpirationOnLastNotification = this.getDaysToExpirationOnLastNotification();
        Integer other$daysToExpirationOnLastNotification = other.getDaysToExpirationOnLastNotification();
        if (this$daysToExpirationOnLastNotification == null ? other$daysToExpirationOnLastNotification != null : !((Object)this$daysToExpirationOnLastNotification).equals(other$daysToExpirationOnLastNotification)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$apiId = this.getApiId();
        String other$apiId = other.getApiId();
        if (this$apiId == null ? other$apiId != null : !this$apiId.equals(other$apiId)) {
            return false;
        }
        String this$environmentId = this.getEnvironmentId();
        String other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !this$environmentId.equals(other$environmentId)) {
            return false;
        }
        String this$planId = this.getPlanId();
        String other$planId = other.getPlanId();
        if (this$planId == null ? other$planId != null : !this$planId.equals(other$planId)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        ZonedDateTime this$processedAt = this.getProcessedAt();
        ZonedDateTime other$processedAt = other.getProcessedAt();
        if (this$processedAt == null ? other$processedAt != null : !((Object)this$processedAt).equals(other$processedAt)) {
            return false;
        }
        String this$requestMessage = this.getRequestMessage();
        String other$requestMessage = other.getRequestMessage();
        if (this$requestMessage == null ? other$requestMessage != null : !this$requestMessage.equals(other$requestMessage)) {
            return false;
        }
        String this$reasonMessage = this.getReasonMessage();
        String other$reasonMessage = other.getReasonMessage();
        if (this$reasonMessage == null ? other$reasonMessage != null : !this$reasonMessage.equals(other$reasonMessage)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        ConsumerStatus this$consumerStatus = this.getConsumerStatus();
        ConsumerStatus other$consumerStatus = other.getConsumerStatus();
        if (this$consumerStatus == null ? other$consumerStatus != null : !((Object)((Object)this$consumerStatus)).equals((Object)other$consumerStatus)) {
            return false;
        }
        String this$processedBy = this.getProcessedBy();
        String other$processedBy = other.getProcessedBy();
        if (this$processedBy == null ? other$processedBy != null : !this$processedBy.equals(other$processedBy)) {
            return false;
        }
        String this$subscribedBy = this.getSubscribedBy();
        String other$subscribedBy = other.getSubscribedBy();
        if (this$subscribedBy == null ? other$subscribedBy != null : !this$subscribedBy.equals(other$subscribedBy)) {
            return false;
        }
        ZonedDateTime this$startingAt = this.getStartingAt();
        ZonedDateTime other$startingAt = other.getStartingAt();
        if (this$startingAt == null ? other$startingAt != null : !((Object)this$startingAt).equals(other$startingAt)) {
            return false;
        }
        ZonedDateTime this$endingAt = this.getEndingAt();
        ZonedDateTime other$endingAt = other.getEndingAt();
        if (this$endingAt == null ? other$endingAt != null : !((Object)this$endingAt).equals(other$endingAt)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        ZonedDateTime this$closedAt = this.getClosedAt();
        ZonedDateTime other$closedAt = other.getClosedAt();
        if (this$closedAt == null ? other$closedAt != null : !((Object)this$closedAt).equals(other$closedAt)) {
            return false;
        }
        ZonedDateTime this$pausedAt = this.getPausedAt();
        ZonedDateTime other$pausedAt = other.getPausedAt();
        if (this$pausedAt == null ? other$pausedAt != null : !((Object)this$pausedAt).equals(other$pausedAt)) {
            return false;
        }
        ZonedDateTime this$consumerPausedAt = this.getConsumerPausedAt();
        ZonedDateTime other$consumerPausedAt = other.getConsumerPausedAt();
        if (this$consumerPausedAt == null ? other$consumerPausedAt != null : !((Object)this$consumerPausedAt).equals(other$consumerPausedAt)) {
            return false;
        }
        String this$generalConditionsContentPageId = this.getGeneralConditionsContentPageId();
        String other$generalConditionsContentPageId = other.getGeneralConditionsContentPageId();
        if (this$generalConditionsContentPageId == null ? other$generalConditionsContentPageId != null : !this$generalConditionsContentPageId.equals(other$generalConditionsContentPageId)) {
            return false;
        }
        SubscriptionConfiguration this$configuration = this.getConfiguration();
        SubscriptionConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$failureCause = this.getFailureCause();
        String other$failureCause = other.getFailureCause();
        return !(this$failureCause == null ? other$failureCause != null : !this$failureCause.equals(other$failureCause));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $generalConditionsContentRevision = this.getGeneralConditionsContentRevision();
        result = result * 59 + ($generalConditionsContentRevision == null ? 43 : ((Object)$generalConditionsContentRevision).hashCode());
        Boolean $generalConditionsAccepted = this.getGeneralConditionsAccepted();
        result = result * 59 + ($generalConditionsAccepted == null ? 43 : ((Object)$generalConditionsAccepted).hashCode());
        Integer $daysToExpirationOnLastNotification = this.getDaysToExpirationOnLastNotification();
        result = result * 59 + ($daysToExpirationOnLastNotification == null ? 43 : ((Object)$daysToExpirationOnLastNotification).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $apiId = this.getApiId();
        result = result * 59 + ($apiId == null ? 43 : $apiId.hashCode());
        String $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : $environmentId.hashCode());
        String $planId = this.getPlanId();
        result = result * 59 + ($planId == null ? 43 : $planId.hashCode());
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        ZonedDateTime $processedAt = this.getProcessedAt();
        result = result * 59 + ($processedAt == null ? 43 : ((Object)$processedAt).hashCode());
        String $requestMessage = this.getRequestMessage();
        result = result * 59 + ($requestMessage == null ? 43 : $requestMessage.hashCode());
        String $reasonMessage = this.getReasonMessage();
        result = result * 59 + ($reasonMessage == null ? 43 : $reasonMessage.hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        ConsumerStatus $consumerStatus = this.getConsumerStatus();
        result = result * 59 + ($consumerStatus == null ? 43 : ((Object)((Object)$consumerStatus)).hashCode());
        String $processedBy = this.getProcessedBy();
        result = result * 59 + ($processedBy == null ? 43 : $processedBy.hashCode());
        String $subscribedBy = this.getSubscribedBy();
        result = result * 59 + ($subscribedBy == null ? 43 : $subscribedBy.hashCode());
        ZonedDateTime $startingAt = this.getStartingAt();
        result = result * 59 + ($startingAt == null ? 43 : ((Object)$startingAt).hashCode());
        ZonedDateTime $endingAt = this.getEndingAt();
        result = result * 59 + ($endingAt == null ? 43 : ((Object)$endingAt).hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        ZonedDateTime $closedAt = this.getClosedAt();
        result = result * 59 + ($closedAt == null ? 43 : ((Object)$closedAt).hashCode());
        ZonedDateTime $pausedAt = this.getPausedAt();
        result = result * 59 + ($pausedAt == null ? 43 : ((Object)$pausedAt).hashCode());
        ZonedDateTime $consumerPausedAt = this.getConsumerPausedAt();
        result = result * 59 + ($consumerPausedAt == null ? 43 : ((Object)$consumerPausedAt).hashCode());
        String $generalConditionsContentPageId = this.getGeneralConditionsContentPageId();
        result = result * 59 + ($generalConditionsContentPageId == null ? 43 : $generalConditionsContentPageId.hashCode());
        SubscriptionConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $failureCause = this.getFailureCause();
        result = result * 59 + ($failureCause == null ? 43 : $failureCause.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SubscriptionEntity(id=" + this.getId() + ", apiId=" + this.getApiId() + ", environmentId=" + this.getEnvironmentId() + ", planId=" + this.getPlanId() + ", applicationId=" + this.getApplicationId() + ", clientId=" + this.getClientId() + ", processedAt=" + this.getProcessedAt() + ", requestMessage=" + this.getRequestMessage() + ", reasonMessage=" + this.getReasonMessage() + ", status=" + this.getStatus() + ", consumerStatus=" + this.getConsumerStatus() + ", processedBy=" + this.getProcessedBy() + ", subscribedBy=" + this.getSubscribedBy() + ", startingAt=" + this.getStartingAt() + ", endingAt=" + this.getEndingAt() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", closedAt=" + this.getClosedAt() + ", pausedAt=" + this.getPausedAt() + ", consumerPausedAt=" + this.getConsumerPausedAt() + ", generalConditionsContentRevision=" + this.getGeneralConditionsContentRevision() + ", generalConditionsContentPageId=" + this.getGeneralConditionsContentPageId() + ", generalConditionsAccepted=" + this.getGeneralConditionsAccepted() + ", daysToExpirationOnLastNotification=" + this.getDaysToExpirationOnLastNotification() + ", configuration=" + this.getConfiguration() + ", metadata=" + this.getMetadata() + ", type=" + this.getType() + ", failureCause=" + this.getFailureCause() + ")";
    }

    @Generated
    public SubscriptionEntity() {
        this.consumerStatus = SubscriptionEntity.$default$consumerStatus();
        this.type = SubscriptionEntity.$default$type();
    }

    @Generated
    public SubscriptionEntity(String id, String apiId, String environmentId, String planId, String applicationId, String clientId, ZonedDateTime processedAt, String requestMessage, String reasonMessage, Status status, ConsumerStatus consumerStatus, String processedBy, String subscribedBy, ZonedDateTime startingAt, ZonedDateTime endingAt, ZonedDateTime createdAt, ZonedDateTime updatedAt, ZonedDateTime closedAt, ZonedDateTime pausedAt, ZonedDateTime consumerPausedAt, Integer generalConditionsContentRevision, String generalConditionsContentPageId, Boolean generalConditionsAccepted, Integer daysToExpirationOnLastNotification, SubscriptionConfiguration configuration, Map<String, String> metadata, Type type, String failureCause) {
        this.id = id;
        this.apiId = apiId;
        this.environmentId = environmentId;
        this.planId = planId;
        this.applicationId = applicationId;
        this.clientId = clientId;
        this.processedAt = processedAt;
        this.requestMessage = requestMessage;
        this.reasonMessage = reasonMessage;
        this.status = status;
        this.consumerStatus = consumerStatus;
        this.processedBy = processedBy;
        this.subscribedBy = subscribedBy;
        this.startingAt = startingAt;
        this.endingAt = endingAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
        this.pausedAt = pausedAt;
        this.consumerPausedAt = consumerPausedAt;
        this.generalConditionsContentRevision = generalConditionsContentRevision;
        this.generalConditionsContentPageId = generalConditionsContentPageId;
        this.generalConditionsAccepted = generalConditionsAccepted;
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
        this.configuration = configuration;
        this.metadata = metadata;
        this.type = type;
        this.failureCause = failureCause;
    }

    public static enum ConsumerStatus {
        STARTED,
        STOPPED,
        FAILURE;

    }

    public static enum Status {
        PENDING,
        REJECTED,
        ACCEPTED,
        CLOSED,
        PAUSED;

    }

    @Generated
    public static class SubscriptionEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String apiId;
        @Generated
        private String environmentId;
        @Generated
        private String planId;
        @Generated
        private String applicationId;
        @Generated
        private String clientId;
        @Generated
        private ZonedDateTime processedAt;
        @Generated
        private String requestMessage;
        @Generated
        private String reasonMessage;
        @Generated
        private Status status;
        @Generated
        private boolean consumerStatus$set;
        @Generated
        private ConsumerStatus consumerStatus$value;
        @Generated
        private String processedBy;
        @Generated
        private String subscribedBy;
        @Generated
        private ZonedDateTime startingAt;
        @Generated
        private ZonedDateTime endingAt;
        @Generated
        private ZonedDateTime createdAt;
        @Generated
        private ZonedDateTime updatedAt;
        @Generated
        private ZonedDateTime closedAt;
        @Generated
        private ZonedDateTime pausedAt;
        @Generated
        private ZonedDateTime consumerPausedAt;
        @Generated
        private Integer generalConditionsContentRevision;
        @Generated
        private String generalConditionsContentPageId;
        @Generated
        private Boolean generalConditionsAccepted;
        @Generated
        private Integer daysToExpirationOnLastNotification;
        @Generated
        private SubscriptionConfiguration configuration;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private boolean type$set;
        @Generated
        private Type type$value;
        @Generated
        private String failureCause;

        @Generated
        SubscriptionEntityBuilder() {
        }

        @Generated
        public SubscriptionEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder planId(String planId) {
            this.planId = planId;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder processedAt(ZonedDateTime processedAt) {
            this.processedAt = processedAt;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder requestMessage(String requestMessage) {
            this.requestMessage = requestMessage;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder reasonMessage(String reasonMessage) {
            this.reasonMessage = reasonMessage;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder status(Status status) {
            this.status = status;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder consumerStatus(ConsumerStatus consumerStatus) {
            this.consumerStatus$value = consumerStatus;
            this.consumerStatus$set = true;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder processedBy(String processedBy) {
            this.processedBy = processedBy;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder subscribedBy(String subscribedBy) {
            this.subscribedBy = subscribedBy;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder startingAt(ZonedDateTime startingAt) {
            this.startingAt = startingAt;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder endingAt(ZonedDateTime endingAt) {
            this.endingAt = endingAt;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder closedAt(ZonedDateTime closedAt) {
            this.closedAt = closedAt;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder pausedAt(ZonedDateTime pausedAt) {
            this.pausedAt = pausedAt;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder consumerPausedAt(ZonedDateTime consumerPausedAt) {
            this.consumerPausedAt = consumerPausedAt;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder generalConditionsContentRevision(Integer generalConditionsContentRevision) {
            this.generalConditionsContentRevision = generalConditionsContentRevision;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder generalConditionsContentPageId(String generalConditionsContentPageId) {
            this.generalConditionsContentPageId = generalConditionsContentPageId;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder generalConditionsAccepted(Boolean generalConditionsAccepted) {
            this.generalConditionsAccepted = generalConditionsAccepted;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder daysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
            this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder configuration(SubscriptionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder type(Type type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @Generated
        public SubscriptionEntityBuilder failureCause(String failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        @Generated
        public SubscriptionEntity build() {
            ConsumerStatus consumerStatus$value = this.consumerStatus$value;
            if (!this.consumerStatus$set) {
                consumerStatus$value = SubscriptionEntity.$default$consumerStatus();
            }
            Type type$value = this.type$value;
            if (!this.type$set) {
                type$value = SubscriptionEntity.$default$type();
            }
            return new SubscriptionEntity(this.id, this.apiId, this.environmentId, this.planId, this.applicationId, this.clientId, this.processedAt, this.requestMessage, this.reasonMessage, this.status, consumerStatus$value, this.processedBy, this.subscribedBy, this.startingAt, this.endingAt, this.createdAt, this.updatedAt, this.closedAt, this.pausedAt, this.consumerPausedAt, this.generalConditionsContentRevision, this.generalConditionsContentPageId, this.generalConditionsAccepted, this.daysToExpirationOnLastNotification, this.configuration, this.metadata, type$value, this.failureCause);
        }

        @Generated
        public String toString() {
            return "SubscriptionEntity.SubscriptionEntityBuilder(id=" + this.id + ", apiId=" + this.apiId + ", environmentId=" + this.environmentId + ", planId=" + this.planId + ", applicationId=" + this.applicationId + ", clientId=" + this.clientId + ", processedAt=" + this.processedAt + ", requestMessage=" + this.requestMessage + ", reasonMessage=" + this.reasonMessage + ", status=" + this.status + ", consumerStatus$value=" + this.consumerStatus$value + ", processedBy=" + this.processedBy + ", subscribedBy=" + this.subscribedBy + ", startingAt=" + this.startingAt + ", endingAt=" + this.endingAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", closedAt=" + this.closedAt + ", pausedAt=" + this.pausedAt + ", consumerPausedAt=" + this.consumerPausedAt + ", generalConditionsContentRevision=" + this.generalConditionsContentRevision + ", generalConditionsContentPageId=" + this.generalConditionsContentPageId + ", generalConditionsAccepted=" + this.generalConditionsAccepted + ", daysToExpirationOnLastNotification=" + this.daysToExpirationOnLastNotification + ", configuration=" + this.configuration + ", metadata=" + this.metadata + ", type$value=" + this.type$value + ", failureCause=" + this.failureCause + ")";
        }
    }

    public static enum Type {
        STANDARD,
        PUSH;

    }
}

