/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PlanAuditEvent;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.domain_service.PlanValidatorDomainService;
import io.gravitee.apim.core.plan.domain_service.ReorderPlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import java.util.Map;
import lombok.Generated;

@UseCase
public class UpdateFederatedPlanUseCase {
    private final PlanCrudService planCrudService;
    private final PlanValidatorDomainService planValidatorService;
    private final ReorderPlanDomainService reorderPlanDomainService;
    private final AuditDomainService auditService;

    public UpdateFederatedPlanUseCase(PlanCrudService planCrudService, PlanValidatorDomainService planValidatorService, ReorderPlanDomainService reorderPlanDomainService, AuditDomainService auditService) {
        this.planCrudService = planCrudService;
        this.planValidatorService = planValidatorService;
        this.reorderPlanDomainService = reorderPlanDomainService;
        this.auditService = auditService;
    }

    public Output execute(Input input) {
        if (input.planToUpdate.getDefinitionVersion() != DefinitionVersion.FEDERATED) {
            throw new IllegalArgumentException(String.format("Can't update a %s plan", input.planToUpdate.getDefinitionVersion()));
        }
        this.planValidatorService.validateGeneralConditionsPageStatus(input.planToUpdate);
        Plan existingPlan = this.planCrudService.findById(input.planToUpdate.getId());
        if (existingPlan.getPlanStatus() == PlanStatus.CLOSED && existingPlan.getPlanStatus() != input.planToUpdate.getPlanStatus()) {
            throw new ValidationDomainException("Invalid status for plan '" + input.planToUpdate.getName() + "'");
        }
        Plan toUpdate = existingPlan.update(input.planToUpdate);
        Plan updated = toUpdate.getOrder() != existingPlan.getOrder() ? this.reorderPlanDomainService.reorderAfterUpdate(toUpdate) : this.planCrudService.update(toUpdate);
        this.createAuditLog(existingPlan, updated, input.auditInfo);
        return new Output(updated);
    }

    private void createAuditLog(Plan oldPlan, Plan newPlan, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(newPlan.getApiId()).event(PlanAuditEvent.PLAN_UPDATED).actor(auditInfo.actor()).oldValue(oldPlan).newValue(newPlan).createdAt(newPlan.getUpdatedAt()).properties(Map.of(AuditProperties.PLAN, newPlan.getId())).build());
    }

    public record Input(Plan planToUpdate, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private Plan planToUpdate;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder planToUpdate(Plan planToUpdate) {
                this.planToUpdate = planToUpdate;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.planToUpdate, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "UpdateFederatedPlanUseCase.Input.InputBuilder(planToUpdate=" + this.planToUpdate + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(Plan updated) {
    }
}

