/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.crd.ApiCRD;
import io.gravitee.apim.infra.adapter.GraviteeJacksonMapper;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import java.io.IOException;
import java.util.stream.Stream;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ValueMapping;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper(uses={PlanAdapter.class})
public interface ApiAdapter {
    public static final Logger LOGGER = LoggerFactory.getLogger(ApiAdapter.class);
    public static final ApiAdapter INSTANCE = (ApiAdapter)Mappers.getMapper(ApiAdapter.class);

    @Mappings(value={@Mapping(target="definitionContext.mode", source="mode"), @Mapping(target="definitionContext.origin", source="origin"), @Mapping(target="apiDefinitionV4", expression="java(deserializeApiDefinitionV4(source))"), @Mapping(target="apiDefinition", expression="java(deserializeApiDefinitionV2(source))")})
    public io.gravitee.apim.core.api.model.Api toCoreModel(io.gravitee.repository.management.model.Api var1);

    public Stream<io.gravitee.apim.core.api.model.Api> toCoreModelStream(Stream<io.gravitee.repository.management.model.Api> var1);

    @Mappings(value={@Mapping(target="mode", source="definitionContext.mode"), @Mapping(target="origin", source="definitionContext.origin"), @Mapping(target="definition", expression="java(serializeApiDefinition(source))")})
    public io.gravitee.repository.management.model.Api toRepository(io.gravitee.apim.core.api.model.Api var1);

    public Stream<io.gravitee.repository.management.model.Api> toRepositoryStream(Stream<io.gravitee.apim.core.api.model.Api> var1);

    @Mapping(target="apiVersion", source="version")
    public NewApiEntity toNewApiEntity(io.gravitee.apim.core.api.model.Api var1);

    @Mapping(target="apiVersion", source="version")
    public Api toApiDefinition(ApiCRD var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mapping(source="version", target="apiVersion")
    public UpdateApiEntity toUpdateApiEntity(ApiCRD var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="version", target="apiVersion"), @Mapping(target="metadata", ignore=true)})
    public ApiEntity toApiEntity(ApiCRD var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="version", target="apiVersion"), @Mapping(target="metadata", ignore=true)})
    public ApiEntity toApiEntity(io.gravitee.apim.core.api.model.Api var1);

    @Mappings(value={@Mapping(source="state", target="lifecycleState"), @Mapping(source="lifecycleState", target="apiLifecycleState")})
    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    public io.gravitee.apim.core.api.model.Api fromApiEntity(GenericApiEntity var1);

    default public Api deserializeApiDefinitionV4(io.gravitee.repository.management.model.Api api) {
        if (api.getDefinition() == null) {
            return null;
        }
        if (api.getDefinitionVersion() == DefinitionVersion.V4) {
            try {
                return (Api)GraviteeJacksonMapper.getInstance().readValue(api.getDefinition(), Api.class);
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while deserializing V4 API definition", (Throwable)ioe);
                return null;
            }
        }
        return null;
    }

    default public io.gravitee.definition.model.Api deserializeApiDefinitionV2(io.gravitee.repository.management.model.Api api) {
        if (api.getDefinition() == null) {
            return null;
        }
        if (api.getDefinitionVersion() != DefinitionVersion.V4) {
            try {
                return (io.gravitee.definition.model.Api)GraviteeJacksonMapper.getInstance().readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while deserializing V2 API definition", (Throwable)ioe);
                return null;
            }
        }
        return null;
    }

    default public String serializeApiDefinition(io.gravitee.apim.core.api.model.Api api) {
        if (api.getDefinitionVersion() == DefinitionVersion.V4) {
            try {
                return GraviteeJacksonMapper.getInstance().writeValueAsString((Object)api.getApiDefinitionV4());
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while serializing V4 API definition", (Throwable)ioe);
                return null;
            }
        }
        try {
            return GraviteeJacksonMapper.getInstance().writeValueAsString((Object)api.getApiDefinition());
        }
        catch (IOException ioe) {
            LOGGER.error("Unexpected error while serializing V2 API definition", (Throwable)ioe);
            return null;
        }
    }
}

