/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.data.domain.Page;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.DictionaryRepository;
import io.gravitee.repository.management.api.EventLatestRepository;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Dictionary;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.Organization;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class EventsLatestUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventsLatestUpgrader.class);
    private static final int BULK_SIZE = 100;
    private final ApiRepository apiRepository;
    private final DictionaryRepository dictionaryRepository;
    private final OrganizationRepository organizationRepository;
    private final EventRepository eventRepository;
    private final EventLatestRepository eventLatestRepository;
    private int modelCounter;
    private int eventsForModelCounter;
    private final ObjectMapper objectMapper;

    @Autowired
    public EventsLatestUpgrader(@Lazy ApiRepository apiRepository, @Lazy DictionaryRepository dictionaryRepository, @Lazy OrganizationRepository organizationRepository, @Lazy EventRepository eventRepository, @Lazy EventLatestRepository eventLatestRepository, @Lazy ObjectMapper objectMapper) {
        this.apiRepository = apiRepository;
        this.dictionaryRepository = dictionaryRepository;
        this.organizationRepository = organizationRepository;
        this.eventRepository = eventRepository;
        this.eventLatestRepository = eventLatestRepository;
        this.objectMapper = objectMapper;
    }

    public int getOrder() {
        return 600;
    }

    public boolean upgrade() {
        try {
            this.migrateApiEvents();
            this.migrateDictionaryEvents();
            this.migrateOrganizationEvents();
        }
        catch (Exception e) {
            log.error("error occurred while applying upgrader {}", (Object)this.getClass().getSimpleName());
            return false;
        }
        return true;
    }

    private void migrateApiEvents() throws TechnicalException {
        log.info("Starting migrating latest event for APIs");
        this.modelCounter = 0;
        this.eventsForModelCounter = 0;
        List emptyCriteria = List.of();
        Page firstPage = this.apiRepository.searchIds(emptyCriteria, new PageableBuilder().pageNumber(0).pageSize(100).build(), null);
        if (firstPage != null && firstPage.getContent() != null) {
            this.migrateEvents(Event.EventProperties.API_ID.getValue(), firstPage.getContent());
            if (firstPage.getTotalElements() > firstPage.getPageElements()) {
                long pageNumber = (int)Math.ceil((double)firstPage.getTotalElements() / 100.0);
                int pageIdx = 1;
                while ((long)pageIdx < pageNumber) {
                    Page nextPage = this.apiRepository.searchIds(emptyCriteria, new PageableBuilder().pageNumber(pageIdx).pageSize(100).build(), null);
                    this.migrateEvents(Event.EventProperties.API_ID.getValue(), nextPage.getContent());
                    ++pageIdx;
                }
            }
        }
        log.info("{} events regarding {} APIs have been migrated", (Object)this.eventsForModelCounter, (Object)this.modelCounter);
    }

    private void migrateDictionaryEvents() throws TechnicalException {
        log.info("Starting migrating latest event for dictionaries");
        this.modelCounter = 0;
        this.eventsForModelCounter = 0;
        Set dictionaries = this.dictionaryRepository.findAll();
        if (dictionaries != null) {
            List<String> ids = dictionaries.stream().map(Dictionary::getId).collect(Collectors.toList());
            this.migrateEvents(Event.EventProperties.DICTIONARY_ID.getValue(), ids);
        }
        log.info("{} events regarding {} dictionaries have been migrated", (Object)this.eventsForModelCounter, (Object)this.modelCounter);
    }

    private void migrateOrganizationEvents() throws TechnicalException {
        log.info("Starting migrating latest event for organizations");
        this.modelCounter = 0;
        this.eventsForModelCounter = 0;
        Set organizations = this.organizationRepository.findAll();
        if (organizations != null) {
            List<String> ids = organizations.stream().map(Organization::getId).collect(Collectors.toList());
            this.migrateEvents(Event.EventProperties.ORGANIZATION_ID.getValue(), ids);
        }
        log.info("{} events regarding {} organizations have been migrated", (Object)this.eventsForModelCounter, (Object)this.modelCounter);
    }

    private void migrateEvents(String propertyId, List<String> ids) throws TechnicalException {
        for (String id : ids) {
            ++this.modelCounter;
            Page search = this.eventRepository.search(EventCriteria.builder().property(propertyId, (Object)id).build(), new PageableBuilder().pageNumber(0).pageSize(1).build());
            if (search.getPageElements() <= 0L) continue;
            Event event = (Event)search.getContent().get(0);
            if (event.getProperties() == null) {
                event.setProperties(new HashMap());
            }
            event.getProperties().put(Event.EventProperties.ID.getValue(), event.getId());
            event.setId(id);
            if (event.getPayload() != null) {
                try {
                    event.setPayload(this.objectMapper.writeValueAsString((Object)this.objectMapper.readTree(event.getPayload())));
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            this.eventLatestRepository.createOrUpdate(event);
            ++this.eventsForModelCounter;
        }
    }
}

