/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.notifiers.impl;

import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notifiers.EmailNotifierService;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailNotifierServiceImpl
implements EmailNotifierService {
    private final Logger LOGGER = LoggerFactory.getLogger(EmailNotifierServiceImpl.class);
    private final EmailService emailService;

    public EmailNotifierServiceImpl(@Autowired EmailService emailService) {
        this.emailService = emailService;
    }

    @Override
    public void trigger(ExecutionContext executionContext, Hook hook, Map<String, Object> templateData, Collection<String> recipients) {
        Optional<EmailNotificationBuilder.EmailTemplate> emailTemplate = this.getEmailTemplateOptional(hook);
        if (emailTemplate.isEmpty()) {
            this.LOGGER.error("Email template not found for hook {}", (Object)hook);
            return;
        }
        if (recipients.isEmpty()) {
            this.LOGGER.error("No emails extracted from {}", recipients);
            return;
        }
        EmailNotificationBuilder template = new EmailNotificationBuilder().template(emailTemplate.get()).params(templateData);
        if (recipients.size() == 1) {
            template.to(recipients.toArray(new String[0]));
        } else {
            template.bcc(recipients.toArray(new String[0]));
        }
        this.emailService.sendAsyncEmailNotification(executionContext, template.build());
    }

    private Optional<EmailNotificationBuilder.EmailTemplate> getEmailTemplateOptional(Hook hook) {
        if (hook == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(EmailNotificationBuilder.EmailTemplate.fromHook(hook));
    }
}

