/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.api;

import io.gravitee.apim.core.api.domain_service.ApiMetadataDomainService;
import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.metadata.crud_service.MetadataCrudService;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApiMetadataDomainServiceLegacyWrapper
extends ApiMetadataDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMetadataDomainServiceLegacyWrapper.class);
    private final ApiMetadataService metadataService;

    public ApiMetadataDomainServiceLegacyWrapper(ApiMetadataService metadataService, AuditDomainService auditDomainService, MetadataCrudService metadataCrudService) {
        super(metadataCrudService, auditDomainService);
        this.metadataService = metadataService;
    }

    @Override
    public void saveApiMetadata(String apiId, List<ApiMetadata> metadata, AuditInfo auditInfo) {
        ExecutionContext executionContext = new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
        metadata.stream().map(apiMetadata -> {
            UpdateApiMetadataEntity updateApiMetadataEntity = new UpdateApiMetadataEntity();
            updateApiMetadataEntity.setApiId(apiId);
            updateApiMetadataEntity.setDefaultValue(apiMetadata.getDefaultValue());
            updateApiMetadataEntity.setFormat(apiMetadata.getFormat());
            updateApiMetadataEntity.setKey(apiMetadata.getKey());
            updateApiMetadataEntity.setName(apiMetadata.getName());
            updateApiMetadataEntity.setValue(apiMetadata.getValue());
            return updateApiMetadataEntity;
        }).forEach(entity -> {
            try {
                this.metadataService.update(executionContext, (UpdateApiMetadataEntity)entity);
            }
            catch (Exception e) {
                log.warn("Unable to save metadata {} for API {}' due to : {}", new Object[]{entity.getName(), apiId, e.getMessage()});
            }
        });
        log.debug("Metadata successfully created for api {}", (Object)apiId);
    }
}

