/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.environment.DisableEnvironmentCommand;
import io.gravitee.cockpit.api.command.environment.DisableEnvironmentPayload;
import io.gravitee.cockpit.api.command.environment.DisableEnvironmentReply;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.gravitee.rest.api.service.v4.ApiStateService;
import io.reactivex.rxjava3.core.Single;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class DisableEnvironmentCommandHandler
implements CommandHandler<DisableEnvironmentCommand, DisableEnvironmentReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DisableEnvironmentCommandHandler.class);
    private final EnvironmentService environmentService;
    private final ApiRepository apiRepository;
    private final ApiStateService apiStateService;
    private final AccessPointCrudService accessPointService;
    private final IdentityProviderActivationService identityProviderActivationService;

    public DisableEnvironmentCommandHandler(EnvironmentService environmentService, ApiStateService apiStateService, @Lazy ApiRepository apiRepository, AccessPointCrudService accessPointService, IdentityProviderActivationService identityProviderActivationService) {
        this.environmentService = environmentService;
        this.apiStateService = apiStateService;
        this.apiRepository = apiRepository;
        this.accessPointService = accessPointService;
        this.identityProviderActivationService = identityProviderActivationService;
    }

    public Command.Type handleType() {
        return Command.Type.DISABLE_ENVIRONMENT_COMMAND;
    }

    public Single<DisableEnvironmentReply> handle(DisableEnvironmentCommand command) {
        DisableEnvironmentPayload payload = (DisableEnvironmentPayload)command.getPayload();
        try {
            EnvironmentEntity environment = this.environmentService.findByCockpitId(payload.getCockpitId());
            ExecutionContext executionContext = new ExecutionContext(environment);
            this.apiRepository.search(new ApiCriteria.Builder().state(LifecycleState.STARTED).environmentId(environment.getId()).build(), new ApiFieldFilter.Builder().excludeDefinition().excludePicture().build()).forEach(api -> this.apiStateService.stop(executionContext, api.getId(), payload.getUserId()));
            this.accessPointService.deleteAccessPoints(AccessPoint.ReferenceType.ENVIRONMENT, environment.getId());
            this.identityProviderActivationService.removeAllIdpsFromTarget(executionContext, new IdentityProviderActivationService.ActivationTarget(environment.getId(), IdentityProviderActivationReferenceType.ENVIRONMENT));
            log.info("Environment [{}] with id [{}] has been disabled.", (Object)environment.getName(), (Object)environment.getId());
            return Single.just((Object)new DisableEnvironmentReply(command.getId(), CommandStatus.SUCCEEDED));
        }
        catch (Exception e) {
            log.error("Error occurred when disabling environment [{}] with id [{}].", new Object[]{payload.getName(), payload.getId(), e});
            return Single.just((Object)new DisableEnvironmentReply(command.getId(), CommandStatus.ERROR));
        }
    }
}

