/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.notification;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.notification.crud_service.NotificationConfigCrudService;
import io.gravitee.apim.core.notification.model.config.NotificationConfig;
import io.gravitee.apim.infra.adapter.NotificationConfigAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.GenericNotificationConfigRepository;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class NotificationConfigCrudServiceImpl
implements NotificationConfigCrudService {
    private final GenericNotificationConfigRepository notificationConfigRepository;

    public NotificationConfigCrudServiceImpl(@Lazy GenericNotificationConfigRepository notificationConfigRepository) {
        this.notificationConfigRepository = notificationConfigRepository;
    }

    @Override
    public NotificationConfig create(NotificationConfig config) {
        try {
            GenericNotificationConfig result = this.notificationConfigRepository.create(NotificationConfigAdapter.INSTANCE.toRepository(config));
            return NotificationConfigAdapter.INSTANCE.toEntity(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurs while trying to create the %s notification config of %s", config.getReferenceType(), config.getReferenceId()), e);
        }
    }
}

