/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.organization.DisableOrganizationCommand;
import io.gravitee.cockpit.api.command.organization.DisableOrganizationPayload;
import io.gravitee.cockpit.api.command.organization.DisableOrganizationReply;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.reactivex.rxjava3.core.Single;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DisableOrganizationCommandHandler
implements CommandHandler<DisableOrganizationCommand, DisableOrganizationReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DisableOrganizationCommandHandler.class);
    private final OrganizationService organizationService;
    private final AccessPointCrudService accessPointService;
    private final IdentityProviderActivationService identityProviderActivationService;

    public DisableOrganizationCommandHandler(OrganizationService organizationService, AccessPointCrudService accessPointService, IdentityProviderActivationService identityProviderActivationService) {
        this.organizationService = organizationService;
        this.accessPointService = accessPointService;
        this.identityProviderActivationService = identityProviderActivationService;
    }

    public Command.Type handleType() {
        return Command.Type.DISABLE_ORGANIZATION_COMMAND;
    }

    public Single<DisableOrganizationReply> handle(DisableOrganizationCommand command) {
        DisableOrganizationPayload organizationPayload = (DisableOrganizationPayload)command.getPayload();
        try {
            OrganizationEntity organization = this.organizationService.findByCockpitId(organizationPayload.getCockpitId());
            this.accessPointService.deleteAccessPoints(AccessPoint.ReferenceType.ORGANIZATION, organization.getId());
            ExecutionContext context = new ExecutionContext(organization.getId());
            this.identityProviderActivationService.removeAllIdpsFromTarget(context, new IdentityProviderActivationService.ActivationTarget(organization.getId(), IdentityProviderActivationReferenceType.ORGANIZATION));
            log.info("Organization [{}] with id [{}] has been disabled.", (Object)organization.getName(), (Object)organization.getId());
            return Single.just((Object)new DisableOrganizationReply(command.getId(), CommandStatus.SUCCEEDED));
        }
        catch (Exception e) {
            log.error("Error occurred when disabling organization [{}] with id [{}].", new Object[]{organizationPayload.getName(), organizationPayload.getId(), e});
            return Single.just((Object)new DisableOrganizationReply(command.getId(), CommandStatus.ERROR));
        }
    }
}

