/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.gateway.model;

import io.gravitee.rest.api.model.InstanceState;
import io.gravitee.rest.api.model.PluginEntity;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class Instance {
    public static final String DEBUG_PLUGIN_ID = "gateway-debug";
    private final String id;
    private String event;
    private Date startedAt;
    private Date lastHeartbeatAt;
    private Date stoppedAt;
    private String hostname;
    private String ip;
    private String port;
    private String tenant;
    private String version;
    private List<String> tags;
    private Set<String> environments;
    private List<String> environmentsHrids;
    private List<String> organizationsHrids;
    private InstanceState state;
    private Map<String, String> systemProperties;
    private Set<PluginEntity> plugins;
    private String clusterId;
    private boolean clusterPrimaryNode;

    public boolean isRunningForEnvironment(String environmentId) {
        return this.environments.contains(environmentId);
    }

    public boolean hasDebugPluginInstalled() {
        return this.plugins.stream().map(PluginEntity::getId).anyMatch(DEBUG_PLUGIN_ID::equalsIgnoreCase);
    }

    @Generated
    private static InstanceState $default$state() {
        return InstanceState.UNKNOWN;
    }

    @Generated
    protected Instance(InstanceBuilder<?, ?> b) {
        this.id = b.id;
        this.event = b.event;
        this.startedAt = b.startedAt;
        this.lastHeartbeatAt = b.lastHeartbeatAt;
        this.stoppedAt = b.stoppedAt;
        this.hostname = b.hostname;
        this.ip = b.ip;
        this.port = b.port;
        this.tenant = b.tenant;
        this.version = b.version;
        this.tags = b.tags;
        this.environments = b.environments;
        this.environmentsHrids = b.environmentsHrids;
        this.organizationsHrids = b.organizationsHrids;
        this.state = b.state$set ? b.state$value : Instance.$default$state();
        this.systemProperties = b.systemProperties;
        this.plugins = b.plugins;
        this.clusterId = b.clusterId;
        this.clusterPrimaryNode = b.clusterPrimaryNode;
    }

    @Generated
    public static InstanceBuilder<?, ?> builder() {
        return new InstanceBuilderImpl();
    }

    @Generated
    public InstanceBuilder<?, ?> toBuilder() {
        return new InstanceBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getEvent() {
        return this.event;
    }

    @Generated
    public Date getStartedAt() {
        return this.startedAt;
    }

    @Generated
    public Date getLastHeartbeatAt() {
        return this.lastHeartbeatAt;
    }

    @Generated
    public Date getStoppedAt() {
        return this.stoppedAt;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public Set<String> getEnvironments() {
        return this.environments;
    }

    @Generated
    public List<String> getEnvironmentsHrids() {
        return this.environmentsHrids;
    }

    @Generated
    public List<String> getOrganizationsHrids() {
        return this.organizationsHrids;
    }

    @Generated
    public InstanceState getState() {
        return this.state;
    }

    @Generated
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Generated
    public Set<PluginEntity> getPlugins() {
        return this.plugins;
    }

    @Generated
    public String getClusterId() {
        return this.clusterId;
    }

    @Generated
    public boolean isClusterPrimaryNode() {
        return this.clusterPrimaryNode;
    }

    @Generated
    public void setEvent(String event) {
        this.event = event;
    }

    @Generated
    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    @Generated
    public void setLastHeartbeatAt(Date lastHeartbeatAt) {
        this.lastHeartbeatAt = lastHeartbeatAt;
    }

    @Generated
    public void setStoppedAt(Date stoppedAt) {
        this.stoppedAt = stoppedAt;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setPort(String port) {
        this.port = port;
    }

    @Generated
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setEnvironments(Set<String> environments) {
        this.environments = environments;
    }

    @Generated
    public void setEnvironmentsHrids(List<String> environmentsHrids) {
        this.environmentsHrids = environmentsHrids;
    }

    @Generated
    public void setOrganizationsHrids(List<String> organizationsHrids) {
        this.organizationsHrids = organizationsHrids;
    }

    @Generated
    public void setState(InstanceState state) {
        this.state = state;
    }

    @Generated
    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Generated
    public void setPlugins(Set<PluginEntity> plugins) {
        this.plugins = plugins;
    }

    @Generated
    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Generated
    public void setClusterPrimaryNode(boolean clusterPrimaryNode) {
        this.clusterPrimaryNode = clusterPrimaryNode;
    }

    @Generated
    public String toString() {
        return "Instance(id=" + this.getId() + ", event=" + this.getEvent() + ", startedAt=" + this.getStartedAt() + ", lastHeartbeatAt=" + this.getLastHeartbeatAt() + ", stoppedAt=" + this.getStoppedAt() + ", hostname=" + this.getHostname() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", tenant=" + this.getTenant() + ", version=" + this.getVersion() + ", tags=" + this.getTags() + ", environments=" + this.getEnvironments() + ", environmentsHrids=" + this.getEnvironmentsHrids() + ", organizationsHrids=" + this.getOrganizationsHrids() + ", state=" + this.getState() + ", systemProperties=" + this.getSystemProperties() + ", plugins=" + this.getPlugins() + ", clusterId=" + this.getClusterId() + ", clusterPrimaryNode=" + this.isClusterPrimaryNode() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Instance;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public static abstract class InstanceBuilder<C extends Instance, B extends InstanceBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String event;
        @Generated
        private Date startedAt;
        @Generated
        private Date lastHeartbeatAt;
        @Generated
        private Date stoppedAt;
        @Generated
        private String hostname;
        @Generated
        private String ip;
        @Generated
        private String port;
        @Generated
        private String tenant;
        @Generated
        private String version;
        @Generated
        private List<String> tags;
        @Generated
        private Set<String> environments;
        @Generated
        private List<String> environmentsHrids;
        @Generated
        private List<String> organizationsHrids;
        @Generated
        private boolean state$set;
        @Generated
        private InstanceState state$value;
        @Generated
        private Map<String, String> systemProperties;
        @Generated
        private Set<PluginEntity> plugins;
        @Generated
        private String clusterId;
        @Generated
        private boolean clusterPrimaryNode;

        @Generated
        protected B $fillValuesFrom(C instance) {
            InstanceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Instance instance, InstanceBuilder<?, ?> b) {
            b.id(instance.id);
            b.event(instance.event);
            b.startedAt(instance.startedAt);
            b.lastHeartbeatAt(instance.lastHeartbeatAt);
            b.stoppedAt(instance.stoppedAt);
            b.hostname(instance.hostname);
            b.ip(instance.ip);
            b.port(instance.port);
            b.tenant(instance.tenant);
            b.version(instance.version);
            b.tags(instance.tags);
            b.environments(instance.environments);
            b.environmentsHrids(instance.environmentsHrids);
            b.organizationsHrids(instance.organizationsHrids);
            b.state(instance.state);
            b.systemProperties(instance.systemProperties);
            b.plugins(instance.plugins);
            b.clusterId(instance.clusterId);
            b.clusterPrimaryNode(instance.clusterPrimaryNode);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B event(String event) {
            this.event = event;
            return this.self();
        }

        @Generated
        public B startedAt(Date startedAt) {
            this.startedAt = startedAt;
            return this.self();
        }

        @Generated
        public B lastHeartbeatAt(Date lastHeartbeatAt) {
            this.lastHeartbeatAt = lastHeartbeatAt;
            return this.self();
        }

        @Generated
        public B stoppedAt(Date stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this.self();
        }

        @Generated
        public B hostname(String hostname) {
            this.hostname = hostname;
            return this.self();
        }

        @Generated
        public B ip(String ip) {
            this.ip = ip;
            return this.self();
        }

        @Generated
        public B port(String port) {
            this.port = port;
            return this.self();
        }

        @Generated
        public B tenant(String tenant) {
            this.tenant = tenant;
            return this.self();
        }

        @Generated
        public B version(String version) {
            this.version = version;
            return this.self();
        }

        @Generated
        public B tags(List<String> tags) {
            this.tags = tags;
            return this.self();
        }

        @Generated
        public B environments(Set<String> environments) {
            this.environments = environments;
            return this.self();
        }

        @Generated
        public B environmentsHrids(List<String> environmentsHrids) {
            this.environmentsHrids = environmentsHrids;
            return this.self();
        }

        @Generated
        public B organizationsHrids(List<String> organizationsHrids) {
            this.organizationsHrids = organizationsHrids;
            return this.self();
        }

        @Generated
        public B state(InstanceState state) {
            this.state$value = state;
            this.state$set = true;
            return this.self();
        }

        @Generated
        public B systemProperties(Map<String, String> systemProperties) {
            this.systemProperties = systemProperties;
            return this.self();
        }

        @Generated
        public B plugins(Set<PluginEntity> plugins) {
            this.plugins = plugins;
            return this.self();
        }

        @Generated
        public B clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this.self();
        }

        @Generated
        public B clusterPrimaryNode(boolean clusterPrimaryNode) {
            this.clusterPrimaryNode = clusterPrimaryNode;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Instance.InstanceBuilder(id=" + this.id + ", event=" + this.event + ", startedAt=" + this.startedAt + ", lastHeartbeatAt=" + this.lastHeartbeatAt + ", stoppedAt=" + this.stoppedAt + ", hostname=" + this.hostname + ", ip=" + this.ip + ", port=" + this.port + ", tenant=" + this.tenant + ", version=" + this.version + ", tags=" + this.tags + ", environments=" + this.environments + ", environmentsHrids=" + this.environmentsHrids + ", organizationsHrids=" + this.organizationsHrids + ", state$value=" + this.state$value + ", systemProperties=" + this.systemProperties + ", plugins=" + this.plugins + ", clusterId=" + this.clusterId + ", clusterPrimaryNode=" + this.clusterPrimaryNode + ")";
        }
    }

    @Generated
    private static final class InstanceBuilderImpl
    extends InstanceBuilder<Instance, InstanceBuilderImpl> {
        @Generated
        private InstanceBuilderImpl() {
        }

        @Override
        @Generated
        protected InstanceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Instance build() {
            return new Instance(this);
        }
    }
}

