/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.google.common.annotations.VisibleForTesting;
import io.gravitee.apim.core.notification.model.Recipient;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.notifier.NotifierPlugin;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.GenericNotificationConfigRepository;
import io.gravitee.repository.management.api.PortalNotificationConfigRepository;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.PortalNotificationConfig;
import io.gravitee.repository.management.model.PortalNotificationDefaultReferenceId;
import io.gravitee.rest.api.model.PluginEntity;
import io.gravitee.rest.api.model.notification.NotifierEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.EmailRecipientsService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PortalNotificationService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.NotifierNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.ApplicationHook;
import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notification.PortalHook;
import io.gravitee.rest.api.service.notifiers.EmailNotifierService;
import io.gravitee.rest.api.service.notifiers.WebhookNotifierService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class NotifierServiceImpl
extends AbstractService
implements NotifierService {
    public static final String DEFAULT_EMAIL_NOTIFIER_ID = "default-email";
    private static final String DEFAULT_WEBHOOK_NOTIFIER_ID = "default-webhook";
    private final Logger LOGGER = LoggerFactory.getLogger(NotifierServiceImpl.class);
    private static final io.gravitee.rest.api.model.NotifierEntity DEFAULT_EMAIL_NOTIFIER = new io.gravitee.rest.api.model.NotifierEntity();
    private final ConfigurablePluginManager<NotifierPlugin> notifierManager;
    private final PortalNotificationConfigRepository portalNotificationConfigRepository;
    private final PortalNotificationService portalNotificationService;
    private final GenericNotificationConfigRepository genericNotificationConfigRepository;
    private final EmailNotifierService emailNotifierService;
    private final WebhookNotifierService webhookNotifierService;
    private final EmailRecipientsService emailRecipientsService;
    private final ParameterService parameterService;

    public NotifierServiceImpl(ConfigurablePluginManager<NotifierPlugin> notifierManager, @Lazy PortalNotificationConfigRepository portalNotificationConfigRepository, PortalNotificationService portalNotificationService, @Lazy GenericNotificationConfigRepository genericNotificationConfigRepository, @Lazy EmailNotifierService emailNotifierService, @Lazy WebhookNotifierService webhookNotifierService, @Lazy EmailRecipientsService emailRecipientsService, @Lazy ParameterService parameterService) {
        this.notifierManager = notifierManager;
        this.portalNotificationConfigRepository = portalNotificationConfigRepository;
        this.portalNotificationService = portalNotificationService;
        this.genericNotificationConfigRepository = genericNotificationConfigRepository;
        this.emailNotifierService = emailNotifierService;
        this.webhookNotifierService = webhookNotifierService;
        this.emailRecipientsService = emailRecipientsService;
        this.parameterService = parameterService;
    }

    @Override
    @Async
    public void trigger(ExecutionContext executionContext, ApiHook hook, String apiId, Map<String, Object> params) {
        this.triggerPortalNotifications(executionContext, hook, NotificationReferenceType.API, apiId, params);
        this.triggerGenericNotifications(executionContext, hook, NotificationReferenceType.API, apiId, params);
    }

    @Override
    @Async
    public void trigger(ExecutionContext executionContext, ApplicationHook hook, String applicationId, Map<String, Object> params) {
        this.triggerPortalNotifications(executionContext, hook, NotificationReferenceType.APPLICATION, applicationId, params);
        this.triggerGenericNotifications(executionContext, hook, NotificationReferenceType.APPLICATION, applicationId, params);
    }

    @Override
    @Async
    public void trigger(ExecutionContext executionContext, ApplicationHook hook, String applicationId, Map<String, Object> params, List<Recipient> recipients) {
        this.triggerPortalNotifications(executionContext, hook, NotificationReferenceType.APPLICATION, applicationId, params);
        this.triggerGenericNotifications(executionContext, hook, NotificationReferenceType.APPLICATION, applicationId, params, recipients);
    }

    @Override
    @Async
    public void trigger(ExecutionContext executionContext, PortalHook hook, Map<String, Object> params) {
        this.triggerPortalNotifications(executionContext, hook, NotificationReferenceType.PORTAL, PortalNotificationDefaultReferenceId.DEFAULT.name(), params);
        this.triggerGenericNotifications(executionContext, hook, NotificationReferenceType.PORTAL, PortalNotificationDefaultReferenceId.DEFAULT.name(), params);
    }

    private void triggerPortalNotifications(ExecutionContext executionContext, Hook hook, NotificationReferenceType refType, String refId, Map<String, Object> params) {
        try {
            List<String> userIds = this.portalNotificationConfigRepository.findByReferenceAndHook(hook.name(), refType, refId).stream().map(PortalNotificationConfig::getUser).collect(Collectors.toList());
            if (!userIds.isEmpty()) {
                this.portalNotificationService.create(executionContext, hook, userIds, params);
            }
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error looking for PortalNotificationConfig with {}/{}/{}", new Object[]{hook, refType, refId, e});
        }
    }

    private void triggerGenericNotifications(ExecutionContext executionContext, Hook hook, NotificationReferenceType refType, String refId, Map<String, Object> params) {
        this.triggerGenericNotifications(executionContext, hook, refType, refId, params, Collections.emptyList());
    }

    @VisibleForTesting
    void triggerGenericNotifications(ExecutionContext executionContext, Hook hook, NotificationReferenceType refType, String refId, Map<String, Object> params, List<Recipient> additionalRecipients) {
        try {
            Map<String, List<GenericNotificationConfig>> notificationConfigs = this.genericNotificationConfigRepository.findByReferenceAndHook(hook.name(), refType, refId).stream().collect(Collectors.groupingBy(GenericNotificationConfig::getNotifier));
            if (!notificationConfigs.isEmpty()) {
                this.list(refType, refId).forEach(notifier -> {
                    switch (notifier.type()) {
                        case EMAIL: {
                            List<String> emailAdditionalRecipients = additionalRecipients.stream().filter(r -> r.type().equals(DEFAULT_EMAIL_NOTIFIER_ID)).map(Recipient::value).toList();
                            List<String> recipients = notificationConfigs.getOrDefault(notifier.getId(), Collections.emptyList()).stream().map(GenericNotificationConfig::getConfig).collect(Collectors.toList());
                            recipients.addAll(emailAdditionalRecipients);
                            Set<String> processedRecipients = this.emailRecipientsService.processTemplatedRecipients(recipients, params);
                            Set<String> validRecipients = this.parameterService.findAsBoolean(executionContext, Key.TRIAL_INSTANCE, ParameterReferenceType.SYSTEM) ? this.emailRecipientsService.filterRegisteredUser(executionContext, processedRecipients) : processedRecipients;
                            this.emailNotifierService.trigger(executionContext, hook, params, validRecipients);
                            break;
                        }
                        case WEBHOOK: {
                            notificationConfigs.getOrDefault(notifier.getId(), Collections.emptyList()).forEach(config -> this.webhookNotifierService.trigger(hook, (GenericNotificationConfig)config, params));
                            break;
                        }
                        default: {
                            this.LOGGER.error("Unknown notifier {}", (Object)notifier.getType());
                        }
                    }
                });
            }
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error looking for GenericNotificationConfig with {}/{}/{}", new Object[]{hook, refType, refId, e});
        }
    }

    @Override
    public List<NotifierEntity> list(NotificationReferenceType referenceType, String referenceId) {
        return Arrays.asList(new NotifierEntity(DEFAULT_EMAIL_NOTIFIER_ID, NotifierEntity.Type.EMAIL, "Default Email Notifier"), new NotifierEntity(DEFAULT_WEBHOOK_NOTIFIER_ID, NotifierEntity.Type.WEBHOOK, "Default Webhook Notifier"));
    }

    @Override
    public Set<io.gravitee.rest.api.model.NotifierEntity> findAll() {
        try {
            this.LOGGER.debug("List all notifiers");
            Collection plugins = this.notifierManager.findAll();
            Set<io.gravitee.rest.api.model.NotifierEntity> notifiers = plugins.stream().map(plugin -> this.convert((NotifierPlugin)plugin, false)).collect(Collectors.toSet());
            notifiers.add(DEFAULT_EMAIL_NOTIFIER);
            return notifiers;
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to list all notifiers", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all notifiers", ex);
        }
    }

    @Override
    public io.gravitee.rest.api.model.NotifierEntity findById(String notifier) {
        this.LOGGER.debug("Find policy by ID: {}", (Object)notifier);
        if (DEFAULT_EMAIL_NOTIFIER_ID.equals(notifier)) {
            return DEFAULT_EMAIL_NOTIFIER;
        }
        NotifierPlugin plugin = (NotifierPlugin)this.notifierManager.get(notifier);
        if (plugin == null) {
            throw new NotifierNotFoundException(notifier);
        }
        return this.convert(plugin, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getSchema(String notifier) {
        try {
            this.LOGGER.debug("Find notifier schema by ID: {}", (Object)notifier);
            if (DEFAULT_EMAIL_NOTIFIER_ID.equals(notifier)) {
                URL url = this.getClass().getResource("/notifiers/default-email.json");
                if (url == null) {
                    throw new IOException("Resource not found for: /notifiers/default-email.json");
                }
                try (InputStream notifierInputStream = url.openStream();){
                    String string;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(notifierInputStream, StandardCharsets.UTF_8));){
                        string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                    }
                    return string;
                }
            }
            return this.notifierManager.getSchema(notifier);
        }
        catch (IOException ioex) {
            this.LOGGER.error("An error occurs while trying to get notifier schema for notifier {}", (Object)notifier, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get notifier schema for notifier " + notifier, ioex);
        }
    }

    private io.gravitee.rest.api.model.NotifierEntity convert(NotifierPlugin plugin, boolean withPlugin) {
        io.gravitee.rest.api.model.NotifierEntity entity = new io.gravitee.rest.api.model.NotifierEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setVersion(plugin.manifest().version());
        if (withPlugin) {
            PluginEntity pluginEntity = new PluginEntity();
            pluginEntity.setPlugin(plugin.clazz());
            pluginEntity.setPath(plugin.path().toString());
            pluginEntity.setType(plugin.type().toString().toLowerCase());
            pluginEntity.setDependencies(plugin.dependencies());
            entity.setPlugin(pluginEntity);
        }
        return entity;
    }

    static {
        DEFAULT_EMAIL_NOTIFIER.setId(DEFAULT_EMAIL_NOTIFIER_ID);
        DEFAULT_EMAIL_NOTIFIER.setName("System email");
        DEFAULT_EMAIL_NOTIFIER.setDescription("System email notifier");
    }
}

