/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.spring;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class InstallationConfiguration {
    private final Environment environment;
    private final String apiURL;
    private final String managementProxyPath;
    private Map<String, String> additionalInformation;

    public InstallationConfiguration(@Value(value="${installation.api.url:http://localhost:8083}") String apiURL, @Value(value="${installation.api.proxyPath.management:${http.api.management.entrypoint:${http.api.entrypoint:/}management}}") String managementProxyPath, Environment environment) {
        this.environment = environment;
        this.apiURL = apiURL;
        this.managementProxyPath = managementProxyPath;
    }

    public Map<String, String> getAdditionalInformation() {
        if (this.additionalInformation == null) {
            this.additionalInformation = this.readPropertyAsMap("installation.additionalInformation");
        }
        return this.additionalInformation;
    }

    private Map<String, String> readPropertyAsMap(String property) {
        String keyName = String.format("%s[%s].%s", property, 0, "name");
        String keyValue = String.format("%s[%s].%s", property, 0, "value");
        HashMap<String, String> properties = new HashMap<String, String>();
        int index = 0;
        while (this.environment.containsProperty(keyName)) {
            String name = this.environment.getProperty(keyName);
            String value = this.environment.getProperty(keyValue);
            if (name != null) {
                properties.put(name.toUpperCase(), value);
            }
            keyName = String.format("%s[%s].%s", property, ++index, "name");
            keyValue = String.format("%s[%s].%s", property, index, "value");
        }
        return properties;
    }

    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }

    @Generated
    public String getApiURL() {
        return this.apiURL;
    }

    @Generated
    public String getManagementProxyPath() {
        return this.managementProxyPath;
    }
}

