/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.notifiers.impl;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.notifiers.WebNotifierService;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebNotifierServiceImpl
implements WebNotifierService {
    private final Logger LOGGER = LoggerFactory.getLogger(WebNotifierServiceImpl.class);
    private static final String HTTPS_SCHEME = "https";
    private final Configuration configuration;
    @Autowired
    private Vertx vertx;

    public WebNotifierServiceImpl(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void request(HttpMethod method, String uri, Map<String, String> headers, String body, boolean useSystemProxy) {
        if (uri == null || uri.isEmpty()) {
            this.LOGGER.error("Webhook Notifier configuration is empty");
            return;
        }
        CompletableFuture future = new CompletableFuture();
        URI requestUri = URI.create(uri);
        boolean ssl = HTTPS_SCHEME.equalsIgnoreCase(requestUri.getScheme());
        HttpClientOptions clientOptions = new HttpClientOptions().setSsl(ssl).setTrustAll(true).setMaxPoolSize(1).setKeepAlive(false).setTcpKeepAlive(false).setConnectTimeout(this.httpClientTimeout().intValue());
        if (useSystemProxy) {
            ProxyOptions proxyOptions = new ProxyOptions();
            proxyOptions.setType(ProxyType.valueOf((String)this.httpClientProxyType()));
            if (HTTPS_SCHEME.equals(requestUri.getScheme())) {
                proxyOptions.setHost(this.httpClientProxyHttpsHost());
                proxyOptions.setPort(this.httpClientProxyHttpsPort().intValue());
                proxyOptions.setUsername(this.httpClientProxyHttpsUsername());
                proxyOptions.setPassword(this.httpClientProxyHttpsPassword());
            } else {
                proxyOptions.setHost(this.httpClientProxyHttpHost());
                proxyOptions.setPort(this.httpClientProxyHttpPort().intValue());
                proxyOptions.setUsername(this.httpClientProxyHttpUsername());
                proxyOptions.setPassword(this.httpClientProxyHttpPassword());
            }
            clientOptions.setProxyOptions(proxyOptions);
        }
        HttpClient httpClient = this.vertx.createHttpClient(clientOptions);
        int port = requestUri.getPort() != -1 ? requestUri.getPort() : (HTTPS_SCHEME.equals(requestUri.getScheme()) ? 443 : 80);
        RequestOptions options = new RequestOptions().setMethod(io.vertx.core.http.HttpMethod.valueOf((String)method.name())).setHost(requestUri.getHost()).setPort(Integer.valueOf(port)).setURI(requestUri.toString()).setTimeout((long)this.httpClientTimeout().intValue());
        options.putHeader("Content-Type", "application/json");
        options.putHeader("Content-Length", Integer.toString(body.getBytes(StandardCharsets.UTF_8).length));
        headers.forEach((arg_0, arg_1) -> ((RequestOptions)options).putHeader(arg_0, arg_1));
        options.putHeader("X-Gravitee-Request-Id", UuidString.generateRandom());
        Future requestFuture = httpClient.request(options);
        requestFuture.onFailure(throwable -> {
            future.completeExceptionally((Throwable)throwable);
            httpClient.close();
        }).onSuccess(request -> {
            request.response(asyncResponse -> {
                if (asyncResponse.failed()) {
                    future.completeExceptionally(asyncResponse.cause());
                    httpClient.close();
                } else {
                    HttpClientResponse response = (HttpClientResponse)asyncResponse.result();
                    this.LOGGER.debug("Web response status code : {}", (Object)response.statusCode());
                    if (WebNotifierServiceImpl.isStatus2xx(response)) {
                        response.bodyHandler(buffer -> {
                            future.complete(buffer);
                            httpClient.close();
                        });
                    } else {
                        future.completeExceptionally(new TechnicalManagementException(" Error on url '" + uri + "'. Status code: " + response.statusCode() + ". Message: " + response.statusMessage(), null));
                    }
                }
            }).exceptionHandler(throwable -> {
                future.completeExceptionally((Throwable)throwable);
                httpClient.close();
            });
            request.end(body);
        });
        try {
            future.get();
        }
        catch (ExecutionException e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new TechnicalManagementException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            throw new TechnicalManagementException(e.getMessage(), e);
        }
    }

    private static boolean isStatus2xx(HttpClientResponse httpResponse) {
        return httpResponse.statusCode() / 100 == 2;
    }

    private Integer httpClientTimeout() {
        return (Integer)this.configuration.getProperty("httpClient.timeout", Integer.class, (Object)10000);
    }

    private String httpClientProxyType() {
        return this.configuration.getProperty("httpClient.proxy.type", "HTTP");
    }

    private String httpClientProxyHttpHost() {
        return this.configuration.getProperty("httpClient.proxy.http.host", System.getProperty("http.proxyHost", "localhost"));
    }

    private Integer httpClientProxyHttpPort() {
        return (Integer)this.configuration.getProperty("httpClient.proxy.http.port", Integer.class, (Object)Integer.valueOf(System.getProperty("http.proxyPort", "3128")));
    }

    private String httpClientProxyHttpUsername() {
        return this.configuration.getProperty("httpClient.proxy.http.username");
    }

    private String httpClientProxyHttpPassword() {
        return this.configuration.getProperty("httpClient.proxy.http.password");
    }

    private String httpClientProxyHttpsHost() {
        return this.configuration.getProperty("httpClient.proxy.https.host", System.getProperty("https.proxyHost", "localhost"));
    }

    private Integer httpClientProxyHttpsPort() {
        return (Integer)this.configuration.getProperty("httpClient.proxy.https.port", Integer.class, (Object)Integer.valueOf(System.getProperty("https.proxyPort", "3128")));
    }

    private String httpClientProxyHttpsUsername() {
        return this.configuration.getProperty("httpClient.proxy.https.username");
    }

    private String httpClientProxyHttpsPassword() {
        return this.configuration.getProperty("httpClient.proxy.https.password");
    }
}

