/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.producer;

import io.gravitee.apim.core.cockpit.query_service.CockpitAccessService;
import io.gravitee.apim.core.installation.domain_service.InstallationTypeDomainService;
import io.gravitee.apim.core.installation.model.InstallationType;
import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandProducer;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.accesspoint.AccessPoint;
import io.gravitee.cockpit.api.command.hello.HelloCommand;
import io.gravitee.cockpit.api.command.hello.HelloPayload;
import io.gravitee.cockpit.api.command.hello.HelloReply;
import io.gravitee.node.api.Node;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.InstallationEntity;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.UpdateEnvironmentEntity;
import io.gravitee.rest.api.model.UpdateOrganizationEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.spring.InstallationConfiguration;
import io.reactivex.rxjava3.core.Single;
import jakarta.annotation.PostConstruct;
import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="cockpitHelloCommandProducer")
public class HelloCommandProducer
implements CommandProducer<HelloCommand, HelloReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HelloCommandProducer.class);
    private static final String PATH_SUFFIX = "/";
    @Value(value="${cockpit.auth.path:/auth/cockpit?token={token}}")
    private String authPath;
    @Value(value="${cockpit.trial:false}")
    private boolean cockpitTrial;
    private final Node node;
    private final InstallationService installationService;
    private final EnvironmentService environmentService;
    private final OrganizationService organizationService;
    private final InstallationTypeDomainService installationTypeDomainService;
    private final CockpitAccessService cockpitAccessService;
    private final InstallationConfiguration configuration;
    private String buildAuthPath;

    @PostConstruct
    public void afterPropertiesSet() {
        String managementProxyPath = this.configuration.getManagementProxyPath();
        StringBuilder authPathBuilder = new StringBuilder(managementProxyPath);
        if (managementProxyPath.endsWith(PATH_SUFFIX) && this.authPath.startsWith(PATH_SUFFIX)) {
            authPathBuilder.append(this.authPath.substring(1));
        } else if (managementProxyPath.endsWith(PATH_SUFFIX) && !this.authPath.startsWith(PATH_SUFFIX) || !managementProxyPath.endsWith(PATH_SUFFIX) && this.authPath.startsWith(PATH_SUFFIX)) {
            authPathBuilder.append(this.authPath);
        } else if (!managementProxyPath.endsWith(PATH_SUFFIX) && !this.authPath.startsWith(PATH_SUFFIX)) {
            authPathBuilder.append(managementProxyPath).append(PATH_SUFFIX).append(this.authPath);
        }
        this.buildAuthPath = authPathBuilder.toString();
    }

    public Command.Type produceType() {
        return Command.Type.HELLO_COMMAND;
    }

    public Single<HelloCommand> prepare(HelloCommand command) {
        InstallationEntity installation = this.installationService.getOrInitialize();
        ((HelloPayload)command.getPayload()).getNode().setInstallationId(installation.getId());
        ((HelloPayload)command.getPayload()).getNode().setHostname(this.node.hostname());
        ((HelloPayload)command.getPayload()).getAdditionalInformation().putAll(installation.getAdditionalInformation());
        InstallationType installationType = this.installationTypeDomainService.get();
        ((HelloPayload)command.getPayload()).setInstallationType(installationType.getLabel());
        ((HelloPayload)command.getPayload()).setTrial(this.cockpitTrial);
        ((HelloPayload)command.getPayload()).getAdditionalInformation().put("AUTH_PATH", this.buildAuthPath);
        ((HelloPayload)command.getPayload()).getAdditionalInformation().putAll(this.configuration.getAdditionalInformation());
        if (installationType == InstallationType.MULTI_TENANT) {
            EnumMap accessPointTemplates = new EnumMap(AccessPoint.Type.class);
            this.cockpitAccessService.getAccessPointsTemplate().forEach((type, accessPoints) -> accessPointTemplates.put(AccessPoint.Type.valueOf((String)type.name()), accessPoints.stream().map(accessPoint -> AccessPoint.builder().host(accessPoint.getHost()).secured(accessPoint.isSecured()).target(AccessPoint.Target.valueOf((String)accessPoint.getTarget().name())).build()).toList()));
            ((HelloPayload)command.getPayload()).setAccessPointsTemplate(accessPointTemplates);
        } else {
            ((HelloPayload)command.getPayload()).getAdditionalInformation().put("AUTH_BASE_URL", this.configuration.getApiURL());
        }
        ((HelloPayload)command.getPayload()).setDefaultOrganizationId(GraviteeContext.getDefaultOrganization());
        ((HelloPayload)command.getPayload()).setDefaultEnvironmentId(GraviteeContext.getDefaultEnvironment());
        return Single.just((Object)command);
    }

    public Single<HelloReply> handleReply(HelloReply reply) {
        if (reply.getCommandStatus() == CommandStatus.SUCCEEDED) {
            Map additionalInformation = this.installationService.getOrInitialize().getAdditionalInformation();
            additionalInformation.put("COCKPIT_INSTALLATION_ID", reply.getInstallationId());
            additionalInformation.put("COCKPIT_INSTALLATION_STATUS", reply.getInstallationStatus());
            this.installationService.setAdditionalInformation(additionalInformation);
            if (reply.getDefaultEnvironmentCockpitId() != null) {
                this.updateDefaultEnvironmentCockpitId(reply.getDefaultEnvironmentCockpitId());
            }
            if (reply.getDefaultOrganizationCockpitId() != null) {
                this.updateDefaultOrganizationCockpitId(reply.getDefaultOrganizationCockpitId());
            }
        }
        return Single.just((Object)reply);
    }

    private void updateDefaultEnvironmentCockpitId(String defaultEnvironmentCockpitId) {
        EnvironmentEntity defaultEnvironment = this.environmentService.getDefaultOrInitialize();
        UpdateEnvironmentEntity updateEnvironment = new UpdateEnvironmentEntity(defaultEnvironment);
        updateEnvironment.setCockpitId(defaultEnvironmentCockpitId);
        this.environmentService.createOrUpdate(defaultEnvironment.getOrganizationId(), defaultEnvironment.getId(), updateEnvironment);
    }

    private void updateDefaultOrganizationCockpitId(String defaultOrganizationCockpitId) {
        OrganizationEntity defaultOrganization = this.organizationService.getDefaultOrInitialize();
        UpdateOrganizationEntity updateOrganization = new UpdateOrganizationEntity(defaultOrganization);
        updateOrganization.setCockpitId(defaultOrganizationCockpitId);
        this.organizationService.updateOrganization(defaultOrganization.getId(), updateOrganization);
    }

    @Generated
    public HelloCommandProducer(Node node, InstallationService installationService, EnvironmentService environmentService, OrganizationService organizationService, InstallationTypeDomainService installationTypeDomainService, CockpitAccessService cockpitAccessService, InstallationConfiguration configuration) {
        this.node = node;
        this.installationService = installationService;
        this.environmentService = environmentService;
        this.organizationService = organizationService;
        this.installationTypeDomainService = installationTypeDomainService;
        this.cockpitAccessService = cockpitAccessService;
        this.configuration = configuration;
    }
}

