/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.api;

import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.api.query_service.ApiMetadataQueryService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ApiMetadataQueryServiceImpl
implements ApiMetadataQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMetadataQueryServiceImpl.class);
    private final MetadataRepository metadataRepository;

    public ApiMetadataQueryServiceImpl(@Lazy MetadataRepository metadataRepository) {
        this.metadataRepository = metadataRepository;
    }

    @Override
    public Map<String, ApiMetadata> findApiMetadata(String apiId) {
        try {
            Map<String, ApiMetadata> apiMetadata = this.metadataRepository.findByReferenceType(MetadataReferenceType.DEFAULT).stream().map(m -> ApiMetadata.builder().key(m.getKey()).defaultValue(m.getValue()).name(m.getName()).format(MetadataFormat.valueOf((String)m.getFormat().name())).build()).collect(Collectors.toMap(ApiMetadata::getKey, Function.identity()));
            this.metadataRepository.findByReferenceTypeAndReferenceId(MetadataReferenceType.API, apiId).forEach(m -> apiMetadata.compute(m.getKey(), (key, existing) -> Optional.ofNullable(existing).map(value -> value.toBuilder().apiId(apiId).name(m.getName()).value(m.getValue()).build()).orElse(ApiMetadata.builder().apiId(m.getReferenceId()).key(m.getKey()).value(m.getValue()).name(m.getName()).format(MetadataFormat.valueOf((String)m.getFormat().name())).build())));
            return apiMetadata;
        }
        catch (TechnicalException e) {
            log.error("An error occurs while trying to find metadata for an API [apiId={}]", (Object)apiId, (Object)e);
            throw new TechnicalManagementException(e);
        }
    }
}

