/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.domain_service;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PlanAuditEvent;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.flow.domain_service.FlowValidationDomainService;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.domain_service.PlanSynchronizationService;
import io.gravitee.apim.core.plan.domain_service.PlanValidatorDomainService;
import io.gravitee.apim.core.plan.domain_service.ReorderPlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UpdatePlanDomainService {
    private final PlanQueryService planQueryService;
    private final PlanCrudService planCrudService;
    private final PlanValidatorDomainService planValidatorDomainService;
    private final FlowValidationDomainService flowValidationDomainService;
    private final FlowCrudService flowCrudService;
    private final AuditDomainService auditService;
    private final PlanSynchronizationService planSynchronizationService;
    private final ReorderPlanDomainService reorderPlanDomainService;

    public UpdatePlanDomainService(PlanQueryService planQueryService, PlanCrudService planCrudService, PlanValidatorDomainService planValidatorDomainService, FlowValidationDomainService flowValidationDomainService, FlowCrudService flowCrudService, AuditDomainService auditService, PlanSynchronizationService planSynchronizationService, ReorderPlanDomainService reorderPlanDomainService) {
        this.planQueryService = planQueryService;
        this.planCrudService = planCrudService;
        this.planValidatorDomainService = planValidatorDomainService;
        this.flowValidationDomainService = flowValidationDomainService;
        this.flowCrudService = flowCrudService;
        this.auditService = auditService;
        this.planSynchronizationService = planSynchronizationService;
        this.reorderPlanDomainService = reorderPlanDomainService;
    }

    public Plan update(Plan planToUpdate, List<Flow> flows, Api api, AuditInfo auditInfo) {
        List<Plan> existingPlans = this.planQueryService.findAllByApiId(api.getId());
        Map<String, PlanStatus> existingPlanStatuses = existingPlans.stream().collect(Collectors.toMap(Plan::getId, Plan::getStatus));
        return this.update(planToUpdate, flows, existingPlanStatuses, api, auditInfo);
    }

    public Plan update(Plan planToUpdate, List<Flow> flows, Map<String, PlanStatus> existingPlanStatuses, Api api, AuditInfo auditInfo) {
        if (existingPlanStatuses.containsKey(planToUpdate.getId()) && existingPlanStatuses.get(planToUpdate.getId()) == PlanStatus.CLOSED && existingPlanStatuses.get(planToUpdate.getId()) != planToUpdate.getStatus()) {
            throw new ValidationDomainException("Invalid status for plan '" + planToUpdate.getName() + "'");
        }
        this.planValidatorDomainService.validatePlanSecurity(planToUpdate, auditInfo.organizationId(), auditInfo.environmentId());
        this.planValidatorDomainService.validatePlanTagsAgainstApiTags(planToUpdate.getTags(), api.getTags());
        this.planValidatorDomainService.validateGeneralConditionsPageStatus(planToUpdate);
        List<Flow> sanitizedFlows = this.flowValidationDomainService.validateAndSanitize(api.getType(), flows);
        this.flowValidationDomainService.validatePathParameters(api.getType(), api.getApiDefinitionV4().getFlows().stream(), sanitizedFlows.stream());
        Plan existingPlan = this.planCrudService.findById(planToUpdate.getId());
        Plan toUpdate = existingPlan.update(planToUpdate);
        if (!this.planSynchronizationService.checkSynchronized(existingPlan, List.of(), toUpdate, sanitizedFlows)) {
            toUpdate.setNeedRedeployAt(Date.from(toUpdate.getUpdatedAt().toInstant()));
        }
        Plan updated = toUpdate.getOrder() != existingPlan.getOrder() ? this.reorderPlanDomainService.reorderAfterUpdate(toUpdate) : this.planCrudService.update(toUpdate);
        this.flowCrudService.savePlanFlows(updated.getId(), sanitizedFlows);
        this.createAuditLog(existingPlan, updated, auditInfo);
        return updated;
    }

    private void createAuditLog(Plan oldPlan, Plan newPlan, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(newPlan.getApiId()).event(PlanAuditEvent.PLAN_UPDATED).actor(auditInfo.actor()).oldValue(oldPlan).newValue(newPlan).createdAt(newPlan.getUpdatedAt()).properties(Map.of(AuditProperties.PLAN, newPlan.getId())).build());
    }
}

