/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.api.domain_service.ApiMetadataDecoderDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.search.Indexer;
import io.gravitee.apim.core.search.model.IndexableApi;
import java.util.Date;
import java.util.Map;

public class ApiIndexerDomainService {
    private final ApiMetadataDecoderDomainService apiMetadataDecoderDomainService;
    private final Indexer indexer;

    public ApiIndexerDomainService(ApiMetadataDecoderDomainService apiMetadataDecoderDomainService, Indexer indexer) {
        this.apiMetadataDecoderDomainService = apiMetadataDecoderDomainService;
        this.indexer = indexer;
    }

    public void index(Indexer.IndexationContext context, Api apiToIndex, PrimaryOwnerEntity primaryOwner) {
        Map<String, String> metadata = this.apiMetadataDecoderDomainService.decodeMetadata(apiToIndex.getId(), ApiMetadataDecoderDomainService.ApiMetadataDecodeContext.builder().name(apiToIndex.getName()).description(apiToIndex.getDescription()).createdAt(Date.from(apiToIndex.getCreatedAt().toInstant())).updatedAt(Date.from(apiToIndex.getUpdatedAt().toInstant())).primaryOwner(new ApiMetadataDecoderDomainService.PrimaryOwnerMetadataDecodeContext(primaryOwner.id(), primaryOwner.displayName(), primaryOwner.email(), primaryOwner.type().name())).build());
        this.indexer.index(context, new IndexableApi(apiToIndex, primaryOwner, metadata));
    }
}

