/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PlansFlowsDefinitionUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlansFlowsDefinitionUpgrader.class);
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private PlanRepository planRepository;
    @Autowired
    private FlowService flowService;
    @Autowired
    private ObjectMapper objectMapper;

    public int getOrder() {
        return 550;
    }

    public boolean upgrade() {
        try {
            AtomicBoolean upgradeFailed = new AtomicBoolean(false);
            this.apiRepository.search(new ApiCriteria.Builder().definitionVersion(List.of(DefinitionVersion.V2)).build(), null, ApiFieldFilter.allFields()).forEach(api -> {
                try {
                    Api apiDefinition = (Api)this.objectMapper.readValue(api.getDefinition(), Api.class);
                    this.migrateApiFlows(api.getId(), apiDefinition);
                }
                catch (Exception e) {
                    upgradeFailed.set(true);
                    throw new RuntimeException(e);
                }
            });
            return !upgradeFailed.get();
        }
        catch (Exception e) {
            log.error("unable to apply upgrader {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
    }

    protected void migrateApiFlows(String apiId, Api apiDefinition) throws Exception {
        log.debug("Migrate flows for api [{}]", (Object)apiId);
        Map plansById = this.planRepository.findByApi(apiId).stream().collect(Collectors.toMap(Plan::getId, Function.identity()));
        this.flowService.save(FlowReferenceType.API, apiDefinition.getId(), apiDefinition.getFlows());
        apiDefinition.getPlans().forEach(apiDefinitionPlan -> {
            if (apiDefinitionPlan.getFlows() != null && !apiDefinitionPlan.getFlows().isEmpty() && plansById.containsKey(apiDefinitionPlan.getId())) {
                this.flowService.save(FlowReferenceType.PLAN, apiDefinitionPlan.getId(), apiDefinitionPlan.getFlows());
            }
        });
    }
}

