/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.subscription;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.apim.core.subscription.query_service.SubscriptionQueryService;
import io.gravitee.apim.infra.adapter.SubscriptionAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Date;
import java.util.List;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SubscriptionQueryServiceImpl
implements SubscriptionQueryService {
    private final SubscriptionRepository subscriptionRepository;
    private final SubscriptionAdapter subscriptionAdapter;

    public SubscriptionQueryServiceImpl(@Lazy SubscriptionRepository subscriptionRepository, SubscriptionAdapter subscriptionAdapter) {
        this.subscriptionRepository = subscriptionRepository;
        this.subscriptionAdapter = subscriptionAdapter;
    }

    @Override
    public List<SubscriptionEntity> findExpiredSubscriptions() {
        SubscriptionCriteria criteria = SubscriptionCriteria.builder().statuses(List.of(SubscriptionStatus.ACCEPTED.name())).endingAtBefore(new Date().getTime()).build();
        try {
            return this.subscriptionRepository.search(criteria).stream().map(this.subscriptionAdapter::toEntity).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to find expired subscription", e);
        }
    }

    @Override
    public List<SubscriptionEntity> findActiveSubscriptionsByPlan(String planId) {
        SubscriptionCriteria criteria = SubscriptionCriteria.builder().plans(List.of(planId)).statuses(List.of(SubscriptionStatus.ACCEPTED.name(), SubscriptionStatus.PENDING.name(), SubscriptionStatus.PAUSED.name())).build();
        try {
            return this.subscriptionRepository.search(criteria).stream().map(this.subscriptionAdapter::toEntity).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to find active plan's subscription", e);
        }
    }
}

