/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api_key.model;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class ApiKeyEntity {
    private String id;
    private String key;
    private String applicationId;
    private List<String> subscriptions = new ArrayList<String>();
    private ZonedDateTime expireAt;
    private ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;
    private boolean revoked;
    private ZonedDateTime revokedAt;
    private boolean paused;
    private Integer daysToExpirationOnLastNotification;

    public ApiKeyEntity revoke() {
        ZonedDateTime now = ZonedDateTime.now();
        return this.toBuilder().revoked(true).updatedAt(now).revokedAt(now).build();
    }

    public boolean isExpired() {
        return this.expireAt != null && ZonedDateTime.now().isAfter(this.getExpireAt());
    }

    public boolean canBeRevoked() {
        return !this.isRevoked() && !this.isExpired();
    }

    public boolean hasSubscription(String subscriptionId) {
        return this.subscriptions.contains(subscriptionId);
    }

    @Generated
    public static ApiKeyEntityBuilder builder() {
        return new ApiKeyEntityBuilder();
    }

    @Generated
    public ApiKeyEntityBuilder toBuilder() {
        return new ApiKeyEntityBuilder().id(this.id).key(this.key).applicationId(this.applicationId).subscriptions(this.subscriptions).expireAt(this.expireAt).createdAt(this.createdAt).updatedAt(this.updatedAt).revoked(this.revoked).revokedAt(this.revokedAt).paused(this.paused).daysToExpirationOnLastNotification(this.daysToExpirationOnLastNotification);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public List<String> getSubscriptions() {
        return this.subscriptions;
    }

    @Generated
    public ZonedDateTime getExpireAt() {
        return this.expireAt;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public boolean isRevoked() {
        return this.revoked;
    }

    @Generated
    public ZonedDateTime getRevokedAt() {
        return this.revokedAt;
    }

    @Generated
    public boolean isPaused() {
        return this.paused;
    }

    @Generated
    public Integer getDaysToExpirationOnLastNotification() {
        return this.daysToExpirationOnLastNotification;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Generated
    public void setSubscriptions(List<String> subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Generated
    public void setExpireAt(ZonedDateTime expireAt) {
        this.expireAt = expireAt;
    }

    @Generated
    public void setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(ZonedDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    @Generated
    public void setRevokedAt(ZonedDateTime revokedAt) {
        this.revokedAt = revokedAt;
    }

    @Generated
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Generated
    public void setDaysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    @Generated
    public String toString() {
        return "ApiKeyEntity(id=" + this.getId() + ", key=" + this.getKey() + ", applicationId=" + this.getApplicationId() + ", subscriptions=" + this.getSubscriptions() + ", expireAt=" + this.getExpireAt() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", revoked=" + this.isRevoked() + ", revokedAt=" + this.getRevokedAt() + ", paused=" + this.isPaused() + ", daysToExpirationOnLastNotification=" + this.getDaysToExpirationOnLastNotification() + ")";
    }

    @Generated
    public ApiKeyEntity(String id, String key, String applicationId, List<String> subscriptions, ZonedDateTime expireAt, ZonedDateTime createdAt, ZonedDateTime updatedAt, boolean revoked, ZonedDateTime revokedAt, boolean paused, Integer daysToExpirationOnLastNotification) {
        this.id = id;
        this.key = key;
        this.applicationId = applicationId;
        this.subscriptions = subscriptions;
        this.expireAt = expireAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.revoked = revoked;
        this.revokedAt = revokedAt;
        this.paused = paused;
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    @Generated
    public ApiKeyEntity() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiKeyEntity)) {
            return false;
        }
        ApiKeyEntity other = (ApiKeyEntity)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiKeyEntity;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public static class ApiKeyEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String key;
        @Generated
        private String applicationId;
        @Generated
        private List<String> subscriptions;
        @Generated
        private ZonedDateTime expireAt;
        @Generated
        private ZonedDateTime createdAt;
        @Generated
        private ZonedDateTime updatedAt;
        @Generated
        private boolean revoked;
        @Generated
        private ZonedDateTime revokedAt;
        @Generated
        private boolean paused;
        @Generated
        private Integer daysToExpirationOnLastNotification;

        @Generated
        ApiKeyEntityBuilder() {
        }

        @Generated
        public ApiKeyEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder subscriptions(List<String> subscriptions) {
            this.subscriptions = subscriptions;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder expireAt(ZonedDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder revoked(boolean revoked) {
            this.revoked = revoked;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder revokedAt(ZonedDateTime revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder paused(boolean paused) {
            this.paused = paused;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder daysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
            this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
            return this;
        }

        @Generated
        public ApiKeyEntity build() {
            return new ApiKeyEntity(this.id, this.key, this.applicationId, this.subscriptions, this.expireAt, this.createdAt, this.updatedAt, this.revoked, this.revokedAt, this.paused, this.daysToExpirationOnLastNotification);
        }

        @Generated
        public String toString() {
            return "ApiKeyEntity.ApiKeyEntityBuilder(id=" + this.id + ", key=" + this.key + ", applicationId=" + this.applicationId + ", subscriptions=" + this.subscriptions + ", expireAt=" + this.expireAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", revoked=" + this.revoked + ", revokedAt=" + this.revokedAt + ", paused=" + this.paused + ", daysToExpirationOnLastNotification=" + this.daysToExpirationOnLastNotification + ")";
        }
    }
}

