/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.gateway.reactive.api.connector.ConnectorFactory;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPlugin;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPluginManager;
import io.gravitee.rest.api.model.platform.plugin.SchemaDisplayFormat;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.v4.EntrypointConnectorPluginService;
import io.gravitee.rest.api.service.v4.impl.AbstractConnectorPluginService;
import java.io.IOException;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component(value="EntrypointPluginServiceImplV4")
public class EntrypointConnectorPluginServiceImpl
extends AbstractConnectorPluginService<EntrypointConnectorPlugin<?, ?>>
implements EntrypointConnectorPluginService {
    public EntrypointConnectorPluginServiceImpl(JsonSchemaService jsonSchemaService, ConfigurablePluginManager<EntrypointConnectorPlugin<?, ?>> pluginManager) {
        super(jsonSchemaService, pluginManager);
    }

    @Override
    protected ConnectorFactory<?> getConnectorFactory(String connectorId) {
        return ((EntrypointConnectorPluginManager)this.pluginManager).getFactoryById(connectorId, true);
    }

    @Override
    public String getSubscriptionSchema(String connectorId, SchemaDisplayFormat schemaDisplayFormat) {
        if (schemaDisplayFormat == SchemaDisplayFormat.GV_SCHEMA_FORM) {
            try {
                this.logger.debug("Find entrypoint subscription schema for format {} by ID: {}", (Object)schemaDisplayFormat, (Object)connectorId);
                String schema = this.pluginManager.getSchema(connectorId, "subscriptions/display-gv-schema-form", true);
                if (schema != null) {
                    return schema;
                }
                this.logger.debug("No specific schema-form exists for this display format. Fall back on default schema-form.");
            }
            catch (IOException ioex) {
                this.logger.debug("Error while getting specific specific schema-form for this display format. Fall back on default schema-form.");
            }
        }
        try {
            this.logger.debug("Find entrypoint subscription schema by ID: {}", (Object)connectorId);
            return ((EntrypointConnectorPluginManager)this.pluginManager).getSubscriptionSchema(connectorId, true);
        }
        catch (IOException ioex) {
            this.logger.error("An error occurs while trying to get entrypoint subscription schema for plugin {}", (Object)connectorId, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get entrypoint subscription schema for plugin " + connectorId, ioex);
        }
    }

    @Override
    public String validateEntrypointSubscriptionConfiguration(String entrypointId, String configuration) {
        this.findById(entrypointId);
        return this.validatePluginConfigurationAgainstSchema(entrypointId, Optional.ofNullable(configuration).orElse("{}"), this::getSubscriptionSchema);
    }
}

