/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.flow;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.infra.adapter.FlowAdapter;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.FlowRepository;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class FlowCrudServiceImpl
extends TransactionalService
implements FlowCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowCrudServiceImpl.class);
    private final FlowRepository flowRepository;

    public FlowCrudServiceImpl(@Lazy FlowRepository flowRepository) {
        this.flowRepository = flowRepository;
    }

    @Override
    public List<Flow> savePlanFlows(String planId, List<Flow> flows) {
        return this.save(FlowReferenceType.PLAN, planId, flows);
    }

    private List<Flow> save(FlowReferenceType referenceType, String referenceId, List<Flow> flows) {
        try {
            log.debug("Save flows for reference {} {}", (Object)referenceType, (Object)referenceId);
            this.flowRepository.deleteByReference(referenceType, referenceId);
            if (flows == null) {
                return List.of();
            }
            ArrayList<Flow> createdFlows = new ArrayList<Flow>();
            for (int order = 0; order < flows.size(); ++order) {
                io.gravitee.repository.management.model.flow.Flow createdFlow = (io.gravitee.repository.management.model.flow.Flow)this.flowRepository.create((Object)FlowAdapter.INSTANCE.toRepository(flows.get(order), referenceType, referenceId, order));
                createdFlows.add(FlowAdapter.INSTANCE.toFlowV4(createdFlow));
            }
            return createdFlows;
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to save flows for " + referenceType + ": " + referenceId;
            log.error(error, (Throwable)ex);
            throw new TechnicalDomainException(error, ex);
        }
    }
}

