/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.rest.api.model.EntrypointEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiEntrypointEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.EntrypointService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.v4.ApiEntrypointService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiEntrypointServiceImpl
implements ApiEntrypointService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiEntrypointServiceImpl.class);
    private static final Pattern DUPLICATE_SLASH_REMOVER = Pattern.compile("(?<!(http:|https:))[//]+");
    private static final String URI_PATH_SEPARATOR = "/";
    private final ParameterService parameterService;
    private final EntrypointService entrypointService;

    public ApiEntrypointServiceImpl(ParameterService parameterService, EntrypointService entrypointService) {
        this.parameterService = parameterService;
        this.entrypointService = entrypointService;
    }

    @Override
    public List<ApiEntrypointEntity> getApiEntrypoints(ExecutionContext executionContext, GenericApiEntity genericApiEntity) {
        ArrayList<ApiEntrypointEntity> apiEntrypoints = new ArrayList<ApiEntrypointEntity>();
        if (genericApiEntity.getTags() != null && !genericApiEntity.getTags().isEmpty()) {
            List<EntrypointEntity> organizationEntrypoints = this.entrypointService.findAll(executionContext);
            organizationEntrypoints.forEach(entrypoint -> {
                String entrypointScheme = this.getScheme(entrypoint.getValue());
                String entrypointValue = entrypoint.getValue();
                HashSet<String> tagEntrypoints = new HashSet<String>(Arrays.asList(entrypoint.getTags()));
                tagEntrypoints.retainAll(genericApiEntity.getTags());
                if (tagEntrypoints.size() == entrypoint.getTags().length) {
                    apiEntrypoints.addAll(this.getEntrypoints(genericApiEntity, entrypointScheme, entrypointValue, tagEntrypoints));
                }
            });
        }
        if (apiEntrypoints.isEmpty()) {
            String defaultEntrypoint = this.parameterService.find(executionContext, Key.PORTAL_ENTRYPOINT, executionContext.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT);
            String defaultScheme = this.getScheme(defaultEntrypoint);
            apiEntrypoints.addAll(this.getEntrypoints(genericApiEntity, defaultScheme, defaultEntrypoint, null));
        }
        return apiEntrypoints;
    }

    private List<ApiEntrypointEntity> getEntrypoints(GenericApiEntity genericApiEntity, String entrypointScheme, String entrypointHost, Set<String> tagEntrypoints) {
        if (genericApiEntity.getDefinitionVersion() != DefinitionVersion.V4) {
            ApiEntity api = (ApiEntity)genericApiEntity;
            return api.getProxy().getVirtualHosts().stream().map(virtualHost -> this.getApiEntrypointEntity(entrypointScheme, entrypointHost, virtualHost.getHost(), virtualHost.getPath(), virtualHost.isOverrideEntrypoint(), tagEntrypoints)).collect(Collectors.toList());
        }
        io.gravitee.rest.api.model.v4.api.ApiEntity api = (io.gravitee.rest.api.model.v4.api.ApiEntity)genericApiEntity;
        return api.getListeners().stream().filter(listener -> listener.getType() == ListenerType.HTTP).flatMap(listener -> {
            HttpListener httpListener = (HttpListener)listener;
            return httpListener.getPaths().stream();
        }).map(path -> this.getApiEntrypointEntity(entrypointScheme, entrypointHost, path.getHost(), path.getPath(), path.isOverrideAccess(), tagEntrypoints)).collect(Collectors.toList());
    }

    private ApiEntrypointEntity getApiEntrypointEntity(String defaultScheme, String entrypointValue, String host, String path, boolean isOverride, Set<String> tags) {
        Object targetHost;
        Object object = targetHost = host == null || !isOverride ? entrypointValue : host;
        if (!((String)targetHost).toLowerCase().startsWith("http")) {
            targetHost = defaultScheme + "://" + (String)targetHost;
        }
        return new ApiEntrypointEntity(tags, DUPLICATE_SLASH_REMOVER.matcher((String)targetHost + URI_PATH_SEPARATOR + path).replaceAll(URI_PATH_SEPARATOR), host);
    }

    private String getScheme(String entrypointValue) {
        String scheme = "https";
        if (entrypointValue != null) {
            try {
                scheme = new URL(entrypointValue).getProtocol();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return scheme;
    }
}

