/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import io.gravitee.apim.core.json.JsonDeserializer;
import io.gravitee.apim.core.json.JsonProcessingException;
import io.gravitee.apim.core.json.JsonSerializer;
import io.gravitee.apim.core.subscription.model.SubscriptionConfiguration;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.repository.management.model.Subscription;
import org.mapstruct.InjectionStrategy;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.NullValueMappingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring", uses={JsonDeserializer.class, JsonDeserializer.class}, injectionStrategy=InjectionStrategy.FIELD, nullValueMappingStrategy=NullValueMappingStrategy.RETURN_NULL)
public abstract class SubscriptionAdapter {
    private final Logger LOGGER = LoggerFactory.getLogger(SubscriptionAdapter.class);
    protected JsonDeserializer jsonDeserializer;
    protected JsonSerializer jsonSerializer;

    @Autowired
    public SubscriptionAdapter setJsonDeserializer(JsonDeserializer jsonDeserializer) {
        this.jsonDeserializer = jsonDeserializer;
        return this;
    }

    @Autowired
    public SubscriptionAdapter setJsonSerializer(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
        return this;
    }

    @Mappings(value={@Mapping(source="api", target="apiId"), @Mapping(source="plan", target="planId"), @Mapping(source="application", target="applicationId"), @Mapping(source="request", target="requestMessage"), @Mapping(source="reason", target="reasonMessage"), @Mapping(target="configuration", expression="java(deserializeConfiguration(subscription.getConfiguration()))")})
    public abstract SubscriptionEntity toEntity(Subscription var1);

    @Mappings(value={@Mapping(source="apiId", target="api"), @Mapping(source="planId", target="plan"), @Mapping(source="applicationId", target="application"), @Mapping(source="requestMessage", target="request"), @Mapping(source="reasonMessage", target="reason"), @Mapping(target="configuration", expression="java(serializeConfiguration(subscription.getConfiguration()))")})
    public abstract Subscription fromEntity(SubscriptionEntity var1);

    @Named(value="deserializeConfiguration")
    public SubscriptionConfiguration deserializeConfiguration(String configuration) {
        if (configuration == null) {
            return null;
        }
        try {
            return this.jsonDeserializer.deserialize(configuration, JacksonSubscriptionConfiguration.class);
        }
        catch (JsonProcessingException e) {
            this.LOGGER.error("Unexpected error while deserializing Subscription configuration", (Throwable)e);
            return null;
        }
    }

    @Named(value="serializeConfiguration")
    public String serializeConfiguration(SubscriptionConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        try {
            return this.jsonSerializer.serialize(configuration);
        }
        catch (JsonProcessingException e) {
            this.LOGGER.error("Unexpected error while serializing Subscription configuration", (Throwable)e);
            return null;
        }
    }

    public static class JacksonSubscriptionConfiguration
    extends SubscriptionConfiguration {
        @JsonSetter
        public void setEntrypointConfiguration(JsonNode configuration) {
            if (configuration != null && !configuration.isNull()) {
                this.setEntrypointConfiguration(configuration.toString());
            }
        }
    }
}

