/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.common;

import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.UserMetadataEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.ReferenceContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class GraviteeContext {
    private static final String DEFAULT_ENVIRONMENT = "DEFAULT";
    private static final String DEFAULT_ORGANIZATION = "DEFAULT";
    private static final String CURRENT_ENVIRONMENT_CONTEXT_KEY = "currentEnvironment";
    private static final String CURRENT_ORGANIZATION_CONTEXT_KEY = "currentOrganization";
    private static final String ROLES_CONTEXT_CACHE_KEY = "currentRoles";
    private static final String USERS_CONTEXT_CACHE_KEY = "currentUsers";
    private static final String USERS_METADATA_CONTEXT_CACHE_KEY = "currentUsersMetadata";
    private static final String PARAMETERS_CONTEXT_CACHE_KEY = "currentParameters";
    private static final ThreadLocal<Map<String, Object>> contextThread = ThreadLocal.withInitial(() -> {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put(CURRENT_ENVIRONMENT_CONTEXT_KEY, "DEFAULT");
        propertiesMap.put(CURRENT_ORGANIZATION_CONTEXT_KEY, "DEFAULT");
        propertiesMap.put(ROLES_CONTEXT_CACHE_KEY, new ConcurrentHashMap());
        propertiesMap.put(USERS_CONTEXT_CACHE_KEY, new ConcurrentHashMap());
        propertiesMap.put(USERS_METADATA_CONTEXT_CACHE_KEY, new ConcurrentHashMap());
        propertiesMap.put(PARAMETERS_CONTEXT_CACHE_KEY, new ConcurrentHashMap());
        return propertiesMap;
    });

    public static void cleanContext() {
        contextThread.remove();
    }

    public static String getCurrentEnvironment() {
        return (String)contextThread.get().get(CURRENT_ENVIRONMENT_CONTEXT_KEY);
    }

    public static void setCurrentEnvironment(String currentEnvironment) {
        contextThread.get().put(CURRENT_ENVIRONMENT_CONTEXT_KEY, currentEnvironment);
    }

    public static String getDefaultEnvironment() {
        return "DEFAULT";
    }

    public static String getCurrentOrganization() {
        return (String)contextThread.get().get(CURRENT_ORGANIZATION_CONTEXT_KEY);
    }

    public static void setCurrentOrganization(String currentOrganization) {
        contextThread.get().put(CURRENT_ORGANIZATION_CONTEXT_KEY, currentOrganization);
    }

    public static String getDefaultOrganization() {
        return "DEFAULT";
    }

    public static ConcurrentMap<Key, String> getCurrentParameters() {
        return (ConcurrentMap)contextThread.get().get(PARAMETERS_CONTEXT_CACHE_KEY);
    }

    public static ConcurrentMap<String, RoleEntity> getCurrentRoles() {
        return (ConcurrentMap)contextThread.get().get(ROLES_CONTEXT_CACHE_KEY);
    }

    public static ConcurrentMap<String, UserEntity> getCurrentUsers() {
        return (ConcurrentMap)contextThread.get().get(USERS_CONTEXT_CACHE_KEY);
    }

    public static ConcurrentMap<String, List<UserMetadataEntity>> getCurrentUsersMetadata() {
        return (ConcurrentMap)contextThread.get().get(USERS_METADATA_CONTEXT_CACHE_KEY);
    }

    public static void fromExecutionContext(ExecutionContext executionContext) {
        GraviteeContext.setCurrentOrganization(executionContext.getOrganizationId());
        if (executionContext.hasEnvironmentId()) {
            GraviteeContext.setCurrentEnvironment(executionContext.getEnvironmentId());
        } else {
            GraviteeContext.setCurrentEnvironment(null);
        }
    }

    public static ExecutionContext getExecutionContext() {
        return new ExecutionContext(GraviteeContext.getCurrentOrganization(), GraviteeContext.getCurrentEnvironment());
    }

    public static ReferenceContext getCurrentContext() {
        if (GraviteeContext.getCurrentEnvironment() == null) {
            return ReferenceContext.builder().referenceType(ReferenceContext.Type.ORGANIZATION).referenceId(GraviteeContext.getCurrentOrganization()).build();
        }
        return ReferenceContext.builder().referenceType(ReferenceContext.Type.ENVIRONMENT).referenceId(GraviteeContext.getCurrentEnvironment()).build();
    }
}

