/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.spring.validator;

import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.settings.logging.MessageSampling;
import jakarta.annotation.PostConstruct;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class GraviteePropertiesValidator {
    private final Configuration configuration;
    private final Validator validator;

    public GraviteePropertiesValidator(Configuration configuration) {
        this.configuration = configuration;
        try (ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();){
            this.validator = validatorFactory.getValidator();
        }
    }

    @PostConstruct
    public void validateProperties() {
        Set<ConstraintViolation<MessageSampling>> constraintViolations = this.validateMessageSamplingSettings();
        if (constraintViolations != null && !constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    private Set<ConstraintViolation<MessageSampling>> validateMessageSamplingSettings() {
        MessageSampling.MessageSamplingBuilder builder = MessageSampling.builder();
        MessageSampling.Count.CountBuilder countBuilder = MessageSampling.Count.builder();
        if (this.configuration.getProperty(Key.LOGGING_MESSAGE_SAMPLING_COUNT_DEFAULT.key(), Integer.class) != null) {
            countBuilder.defaultValue((Integer)this.configuration.getProperty(Key.LOGGING_MESSAGE_SAMPLING_COUNT_DEFAULT.key(), Integer.class));
        }
        if (this.configuration.getProperty(Key.LOGGING_MESSAGE_SAMPLING_COUNT_LIMIT.key(), Integer.class) != null) {
            countBuilder.limit((Integer)this.configuration.getProperty(Key.LOGGING_MESSAGE_SAMPLING_COUNT_LIMIT.key(), Integer.class));
        }
        MessageSampling.Probabilistic.ProbabilisticBuilder probabilisticSettingsBuilder = MessageSampling.Probabilistic.builder();
        if (this.configuration.getProperty(Key.LOGGING_MESSAGE_SAMPLING_PROBABILISTIC_DEFAULT.key(), Double.class) != null) {
            probabilisticSettingsBuilder.defaultValue((Double)this.configuration.getProperty(Key.LOGGING_MESSAGE_SAMPLING_PROBABILISTIC_DEFAULT.key(), Double.class));
        }
        if (this.configuration.getProperty(Key.LOGGING_MESSAGE_SAMPLING_PROBABILISTIC_LIMIT.key(), Double.class) != null) {
            probabilisticSettingsBuilder.limit((Double)this.configuration.getProperty(Key.LOGGING_MESSAGE_SAMPLING_PROBABILISTIC_LIMIT.key(), Double.class));
        }
        MessageSampling.Temporal.TemporalBuilder temporalSettingsBuilder = MessageSampling.Temporal.builder();
        if (this.configuration.getProperty(Key.LOGGING_MESSAGE_SAMPLING_TEMPORAL_DEFAULT.key(), String.class) != null) {
            temporalSettingsBuilder.defaultValue((String)this.configuration.getProperty(Key.LOGGING_MESSAGE_SAMPLING_TEMPORAL_DEFAULT.key(), String.class));
        }
        if (this.configuration.getProperty(Key.LOGGING_MESSAGE_SAMPLING_TEMPORAL_LIMIT.key(), String.class) != null) {
            temporalSettingsBuilder.limit((String)this.configuration.getProperty(Key.LOGGING_MESSAGE_SAMPLING_TEMPORAL_LIMIT.key(), String.class));
        }
        MessageSampling messageSampling = builder.count(countBuilder.build()).probabilistic(probabilisticSettingsBuilder.build()).temporal(temporalSettingsBuilder.build()).build();
        return this.validator.validate((Object)messageSampling, new Class[0]);
    }
}

