/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.audit;

import io.gravitee.apim.core.audit.crud_service.AuditCrudService;
import io.gravitee.apim.core.audit.model.AuditEntity;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AuditRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Date;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AuditCrudServiceImpl
implements AuditCrudService {
    private final AuditRepository auditRepository;

    public AuditCrudServiceImpl(@Lazy AuditRepository auditRepository) {
        this.auditRepository = auditRepository;
    }

    @Override
    public void create(AuditEntity auditEntity) throws TechnicalManagementException {
        Audit entity = Audit.builder().id(auditEntity.getId()).organizationId(auditEntity.getOrganizationId()).environmentId(auditEntity.getEnvironmentId()).createdAt(Date.from(auditEntity.getCreatedAt().toInstant())).user(auditEntity.getUser()).properties(auditEntity.getProperties()).referenceType(Audit.AuditReferenceType.valueOf((String)auditEntity.getReferenceType().name())).referenceId(auditEntity.getReferenceId()).event(auditEntity.getEvent()).patch(auditEntity.getPatch()).build();
        try {
            this.auditRepository.create((Object)entity);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }
}

