/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.membership;

import io.gravitee.apim.core.api.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.application.domain_service.ApplicationPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.exception.ApiPrimaryOwnerNotFoundException;
import io.gravitee.apim.core.membership.exception.ApplicationPrimaryOwnerNotFoundException;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.GroupRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipMemberType;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.Role;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PrimaryOwnerDomainServiceImpl
implements ApiPrimaryOwnerDomainService,
ApplicationPrimaryOwnerDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrimaryOwnerDomainServiceImpl.class);
    private final RoleRepository roleRepository;
    private final MembershipRepository membershipRepository;
    private final UserCrudService userCrudService;
    private final GroupRepository groupRepository;

    public PrimaryOwnerDomainServiceImpl(@Lazy RoleRepository roleRepository, @Lazy MembershipRepository membershipRepository, UserCrudService userCrudService, @Lazy GroupRepository groupRepository) {
        this.roleRepository = roleRepository;
        this.membershipRepository = membershipRepository;
        this.userCrudService = userCrudService;
        this.groupRepository = groupRepository;
    }

    @Override
    public PrimaryOwnerEntity getApiPrimaryOwner(String organizationId, String apiId) throws ApiPrimaryOwnerNotFoundException {
        return (PrimaryOwnerEntity)this.findPrimaryOwnerRole(organizationId, RoleScope.API).flatMap(role -> this.findApiPrimaryOwnerMembership(apiId, (Role)role).flatMap(membership -> switch (membership.getMemberType()) {
            default -> throw new IncompatibleClassChangeError();
            case MembershipMemberType.USER -> this.findUserPrimaryOwner((Membership)membership);
            case MembershipMemberType.GROUP -> this.findGroupPrimaryOwner((Membership)membership, role.getId());
        })).orElseThrow(() -> new ApiPrimaryOwnerNotFoundException(apiId));
    }

    @Override
    public PrimaryOwnerEntity getApplicationPrimaryOwner(String organizationId, String applicationId) throws ApplicationPrimaryOwnerNotFoundException {
        return (PrimaryOwnerEntity)this.findPrimaryOwnerRole(organizationId, RoleScope.APPLICATION).flatMap(role -> this.findApplicationPrimaryOwnerMembership(applicationId, (Role)role).flatMap(membership -> switch (membership.getMemberType()) {
            default -> throw new IncompatibleClassChangeError();
            case MembershipMemberType.USER -> this.findUserPrimaryOwner((Membership)membership);
            case MembershipMemberType.GROUP -> this.findGroupPrimaryOwner((Membership)membership, role.getId());
        })).orElseThrow(() -> new ApplicationPrimaryOwnerNotFoundException(applicationId));
    }

    private Optional<Role> findPrimaryOwnerRole(String organizationId, RoleScope scope) {
        try {
            return this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(scope, SystemRole.PRIMARY_OWNER.name(), organizationId, RoleReferenceType.ORGANIZATION);
        }
        catch (TechnicalException e) {
            log.error("An error occurs while trying to get primary owner role for [organizationId={}]", (Object)organizationId, (Object)e);
            throw new TechnicalManagementException(e);
        }
    }

    private Optional<Membership> findApiPrimaryOwnerMembership(String apiId, Role role) {
        try {
            return this.membershipRepository.findByReferenceAndRoleId(MembershipReferenceType.API, apiId, role.getId()).stream().findFirst();
        }
        catch (TechnicalException e) {
            log.error("An error occurs while trying to get primary owner for [apiId={}]", (Object)apiId, (Object)e);
            throw new TechnicalManagementException(e);
        }
    }

    private Optional<Membership> findApplicationPrimaryOwnerMembership(String applicationId, Role role) {
        try {
            return this.membershipRepository.findByReferenceAndRoleId(MembershipReferenceType.APPLICATION, applicationId, role.getId()).stream().findFirst();
        }
        catch (TechnicalException e) {
            log.error("An error occurs while trying to get primary owner for [applicationId={}]", (Object)applicationId, (Object)e);
            throw new TechnicalManagementException(e);
        }
    }

    private Optional<PrimaryOwnerEntity> findUserPrimaryOwner(Membership membership) {
        return this.userCrudService.findBaseUserById(membership.getMemberId()).map(user -> PrimaryOwnerEntity.builder().id(user.getId()).displayName(user.displayName()).email(user.getEmail()).type("USER").build());
    }

    private Optional<PrimaryOwnerEntity> findGroupPrimaryOwner(Membership membership, String primaryOwnerRoleId) {
        try {
            Optional group = this.groupRepository.findById((Object)membership.getMemberId());
            Optional user = this.findPrimaryOwnerGroupMember(membership.getMemberId(), primaryOwnerRoleId).flatMap(m -> this.userCrudService.findBaseUserById(m.getMemberId()));
            return group.map(value -> PrimaryOwnerEntity.builder().id(value.getId()).displayName(value.getName()).type("GROUP").email(user.map(BaseUserEntity::getEmail).orElse(null)).build());
        }
        catch (TechnicalException e) {
            log.error("An error occurs while trying to get group [groupId={}]", (Object)membership.getMemberId(), (Object)e);
            throw new TechnicalManagementException(e);
        }
    }

    private Optional<Membership> findPrimaryOwnerGroupMember(String groupId, String primaryOwnerRoleId) {
        try {
            return this.membershipRepository.findByReferenceAndRoleId(MembershipReferenceType.GROUP, groupId, primaryOwnerRoleId).stream().findFirst();
        }
        catch (TechnicalException e) {
            log.error("An error occurs while trying to get group member for [groupId={}]", (Object)groupId, (Object)e);
            throw new TechnicalManagementException(e);
        }
    }
}

