/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.UpdateOrganizationEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.gravitee.rest.api.service.exceptions.OrganizationNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class OrganizationServiceImpl
extends TransactionalService
implements OrganizationService {
    private final Logger LOGGER = LoggerFactory.getLogger(OrganizationServiceImpl.class);
    @Lazy
    @Autowired
    private OrganizationRepository organizationRepository;
    @Autowired
    private RoleService roleService;
    @Autowired
    private FlowService flowService;
    @Autowired
    private EventService eventService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ObjectMapper mapper;

    @Override
    public OrganizationEntity findById(String organizationId) {
        try {
            this.LOGGER.debug("Find organization by ID: {}", (Object)organizationId);
            Optional optOrganization = this.organizationRepository.findById((Object)organizationId);
            if (!optOrganization.isPresent()) {
                throw new OrganizationNotFoundException(organizationId);
            }
            return this.convert((Organization)optOrganization.get());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find organization by ID", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find organization by ID", ex);
        }
    }

    @Override
    public OrganizationEntity updateOrganization(String organizationId, UpdateOrganizationEntity organizationEntity) {
        try {
            Optional organizationOptional = this.organizationRepository.findById((Object)organizationId);
            if (organizationOptional.isPresent()) {
                Organization organization = this.convert(organizationEntity);
                organization.setId(((Organization)organizationOptional.get()).getId());
                OrganizationEntity updatedOrganization = this.convert((Organization)this.organizationRepository.update((Object)organization));
                this.createPublishOrganizationEvent(updatedOrganization);
                return updatedOrganization;
            }
            throw new OrganizationNotFoundException(organizationId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update organization {}", (Object)organizationEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update organization " + organizationEntity.getName(), ex);
        }
    }

    @Override
    public OrganizationEntity createOrUpdate(String organizationId, UpdateOrganizationEntity organizationEntity) {
        try {
            try {
                return this.updateOrganizationAndFlows(organizationId, organizationEntity);
            }
            catch (OrganizationNotFoundException e) {
                Organization organization = this.convert(organizationEntity);
                organization.setId(organizationId);
                this.flowService.save(FlowReferenceType.ORGANIZATION, organizationId, organizationEntity.getFlows());
                OrganizationEntity createdOrganization = this.convert((Organization)this.organizationRepository.create((Object)organization));
                ExecutionContext executionContext = new ExecutionContext(organizationId);
                this.roleService.initialize(executionContext, createdOrganization.getId());
                this.roleService.createOrUpdateSystemRoles(executionContext, createdOrganization.getId());
                this.createPublishOrganizationEvent(createdOrganization);
                return createdOrganization;
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update organization {}", (Object)organizationEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update organization " + organizationEntity.getName(), ex);
        }
    }

    @Override
    public OrganizationEntity updateOrganizationAndFlows(String organizationId, UpdateOrganizationEntity organizationEntity) {
        try {
            Optional organizationOptional = this.organizationRepository.findById((Object)organizationId);
            if (organizationOptional.isPresent()) {
                this.flowService.save(FlowReferenceType.ORGANIZATION, organizationId, organizationEntity.getFlows());
                Organization organization = this.convert(organizationEntity);
                organization.setId(organizationId);
                OrganizationEntity updatedOrganization = this.convert((Organization)this.organizationRepository.update((Object)organization));
                this.createPublishOrganizationEvent(updatedOrganization);
                return updatedOrganization;
            }
            throw new OrganizationNotFoundException(organizationId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update organization {}", (Object)organizationEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update organization " + organizationEntity.getName(), ex);
        }
    }

    private void createPublishOrganizationEvent(OrganizationEntity organizationEntity) {
        Set<String> environmentIds = this.environmentService.findByOrganization(organizationEntity.getId()).stream().map(EnvironmentEntity::getId).collect(Collectors.toSet());
        this.eventService.createOrganizationEvent(new ExecutionContext(organizationEntity.getId()), environmentIds, EventType.PUBLISH_ORGANIZATION, organizationEntity);
    }

    @Override
    public Long count() {
        try {
            return this.organizationRepository.count();
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to count organizations", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to count organizations ", ex);
        }
    }

    @Override
    public void delete(String organizationId) {
        try {
            Optional organizationOptional = this.organizationRepository.findById((Object)organizationId);
            if (organizationOptional.isPresent()) {
                this.organizationRepository.delete((Object)organizationId);
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete organization {}", (Object)organizationId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete organization " + organizationId, ex);
        }
    }

    private Organization convert(UpdateOrganizationEntity organizationEntity) {
        Organization organization = new Organization();
        organization.setHrids(organizationEntity.getHrids());
        organization.setCockpitId(organizationEntity.getCockpitId());
        organization.setName(organizationEntity.getName());
        organization.setDescription(organizationEntity.getDescription());
        String flowMode = organizationEntity.getFlowMode() != null ? organizationEntity.getFlowMode().name() : FlowMode.DEFAULT.name();
        organization.setFlowMode(flowMode);
        return organization;
    }

    private OrganizationEntity convert(Organization organization) {
        OrganizationEntity organizationEntity = new OrganizationEntity();
        organizationEntity.setId(organization.getId());
        organizationEntity.setCockpitId(organization.getCockpitId());
        organizationEntity.setHrids(organization.getHrids());
        organizationEntity.setName(organization.getName());
        organizationEntity.setDescription(organization.getDescription());
        FlowMode flowMode = organization.getFlowMode() != null ? FlowMode.valueOf((String)organization.getFlowMode()) : FlowMode.DEFAULT;
        organizationEntity.setFlowMode(flowMode);
        List<Flow> flows = this.flowService.findByReference(FlowReferenceType.ORGANIZATION, organization.getId());
        organizationEntity.setFlows(flows);
        return organizationEntity;
    }

    @Override
    public OrganizationEntity initialize() {
        Organization defaultOrganization = new Organization();
        defaultOrganization.setId(GraviteeContext.getDefaultOrganization());
        defaultOrganization.setName("Default organization");
        defaultOrganization.setHrids(Collections.singletonList("default"));
        defaultOrganization.setDescription("Default organization");
        try {
            this.organizationRepository.create((Object)defaultOrganization);
            return this.convert(defaultOrganization);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create default organization", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to create default organization", ex);
        }
    }

    @Override
    public Collection<OrganizationEntity> findAll() {
        try {
            return this.organizationRepository.findAll().stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to list all organizations", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all organizations", ex);
        }
    }

    @Override
    public OrganizationEntity getDefaultOrInitialize() {
        try {
            return this.organizationRepository.findById((Object)GraviteeContext.getDefaultOrganization()).map(this::convert).orElseGet(this::initialize);
        }
        catch (Exception ex) {
            this.LOGGER.error("Error while getting installation : {}", (Object)ex.getMessage());
            throw new TechnicalManagementException("Error while getting installation", ex);
        }
    }

    @Override
    public OrganizationEntity findByCockpitId(String cockpitId) {
        try {
            this.LOGGER.debug("Find organization by cockpit id");
            return this.organizationRepository.findByCockpitId(cockpitId).map(this::convert).orElseThrow(() -> new OrganizationNotFoundException(cockpitId));
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find organization by cockpit id {}", (Object)cockpitId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find organization by cockpit id " + cockpitId, ex);
        }
    }
}

