/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.subscription.use_case;

import io.gravitee.apim.core.TransactionalUseCase;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.environment.crud_service.EnvironmentCrudService;
import io.gravitee.apim.core.environment.model.Environment;
import io.gravitee.apim.core.subscription.domain_service.CloseSubscriptionDomainService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.apim.core.subscription.query_service.SubscriptionQueryService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@TransactionalUseCase
public class CloseExpiredSubscriptionsUseCase {
    private final SubscriptionQueryService subscriptionQueryService;
    private final ApiQueryService apiQueryService;
    private final EnvironmentCrudService environmentCrudService;
    private final CloseSubscriptionDomainService closeSubscriptionDomainService;

    public CloseExpiredSubscriptionsUseCase(SubscriptionQueryService subscriptionQueryService, ApiQueryService apiQueryService, EnvironmentCrudService environmentCrudService, CloseSubscriptionDomainService closeSubscriptionDomainService) {
        this.subscriptionQueryService = subscriptionQueryService;
        this.apiQueryService = apiQueryService;
        this.environmentCrudService = environmentCrudService;
        this.closeSubscriptionDomainService = closeSubscriptionDomainService;
    }

    public Output execute(Input input) {
        List<SubscriptionEntity> toClose = this.subscriptionQueryService.findExpiredSubscriptions();
        List<String> apiIds = toClose.stream().map(SubscriptionEntity::getApiId).toList();
        Map<String, Api> apis = this.apiQueryService.search(ApiSearchCriteria.builder().ids(apiIds).build(), null, ApiFieldFilter.builder().pictureExcluded(true).definitionExcluded(true).build()).collect(Collectors.toMap(Api::getId, api -> api));
        List<SubscriptionEntity> closed = toClose.stream().map(subscription -> {
            Environment environment = this.environmentCrudService.get(((Api)apis.get(subscription.getApiId())).getEnvironmentId());
            AuditInfo auditInfo = AuditInfo.builder().organizationId(environment.getOrganizationId()).environmentId(environment.getId()).actor(input.auditActor).build();
            return this.closeSubscriptionDomainService.closeSubscription(subscription.getId(), auditInfo);
        }).toList();
        return new Output(closed);
    }

    public record Input(AuditActor auditActor) {
    }

    public record Output(List<SubscriptionEntity> closedSubscriptions) {
    }
}

