/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.common.data.domain.Page;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PageHRIDUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageHRIDUpgrader.class);
    private static final int PAGE_SIZE = 100;
    @Lazy
    @Autowired
    private PageRepository pageRepository;

    public boolean upgrade() {
        int pageNumber = 0;
        long updatedCount = 0L;
        try {
            Pageable pageable;
            Page pagedResult;
            List pages;
            while (!(pages = (pagedResult = this.pageRepository.findAll(pageable = new PageableBuilder().pageNumber(pageNumber).pageSize(100).build())).getContent()).isEmpty()) {
                for (io.gravitee.repository.management.model.Page page : pages) {
                    page.setHrid(page.getId());
                    this.pageRepository.update(page);
                    ++updatedCount;
                    log.debug("Updated HRID for page {}", (Object)page.getId());
                }
                if (pages.size() < 100) break;
                ++pageNumber;
            }
            log.info("Page HRID upgrade completed. Total pages updated: {}", (Object)updatedCount);
            return true;
        }
        catch (TechnicalException e) {
            log.error("Error during Page HRID upgrade", (Throwable)e);
            return false;
        }
    }

    public int getOrder() {
        return 710;
    }
}

