/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.utils;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import java.util.Objects;
import lombok.Generated;

public final class LuceneTransformerUtils {
    public static String generateApiType(Api api) {
        boolean isTcpApi = api.getType() == ApiType.PROXY && Objects.nonNull(api.getApiListeners()) && api.getApiListeners().stream().anyMatch(listener -> listener.getType() == ListenerType.TCP);
        return LuceneTransformerUtils.generateApiType(api.getDefinitionVersion(), api.getType(), isTcpApi);
    }

    public static String generateApiType(GenericApiEntity api) {
        if (api instanceof ApiEntity) {
            return LuceneTransformerUtils.generateApiType((ApiEntity)api);
        }
        return api.getDefinitionVersion().name();
    }

    private static String generateApiType(ApiEntity api) {
        boolean isTcpApi = api.getType() == ApiType.PROXY && Objects.nonNull(api.getListeners()) && api.getListeners().stream().anyMatch(listener -> listener.getType() == ListenerType.TCP);
        return LuceneTransformerUtils.generateApiType(api.getDefinitionVersion(), api.getType(), isTcpApi);
    }

    private static String generateApiType(DefinitionVersion definitionVersion, ApiType apiType, boolean isTcpApi) {
        if (definitionVersion == DefinitionVersion.V4) {
            String type = switch (apiType) {
                default -> throw new MatchException(null, null);
                case ApiType.A2A_PROXY -> "A2A_PROXY";
                case ApiType.LLM_PROXY -> "LLM_PROXY";
                case ApiType.MCP_PROXY -> "MCP_PROXY";
                case ApiType.MESSAGE -> "MESSAGE";
                case ApiType.NATIVE -> "KAFKA";
                case ApiType.PROXY -> isTcpApi ? "TCP_PROXY" : "HTTP_PROXY";
            };
            return definitionVersion.name() + "_" + type;
        }
        return definitionVersion.name();
    }

    @Generated
    private LuceneTransformerUtils() {
    }
}

