/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.service.MediaValidationService;
import io.gravitee.rest.api.service.exceptions.UploadUnauthorized;
import java.io.IOException;
import java.util.Set;
import lombok.Generated;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionImportData;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionLaunch;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionSubmitForm;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MediaValidationServiceImpl
implements MediaValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MediaValidationServiceImpl.class);
    private static final Tika TIKA = new Tika();
    private static final Set<String> FORBIDDEN_TYPES = Set.of("application/java-archive", "application/x-dosexec", "application/x-msdownload", "application/x-ms-installer", "application/x-shockwave-flash", "application/x-bsh", "application/x-sh", "application/x-csh", "application/javascript", "application/vbscript", "application/sql", "application/x-executable", "application/bat", "application/x-bat", "application/octet-stream", "text/x-script.sh");

    @Override
    public void validate(MediaEntity mediaEntity) {
        String detectedMediaType;
        if (mediaEntity == null || mediaEntity.getData() == null) {
            log.debug("Validation skipped: mediaEntity or data is null");
            return;
        }
        if (mediaEntity.getType() == null || mediaEntity.getSubType() == null) {
            log.warn("Validation failed for file '{}': missing media type", (Object)mediaEntity.getFileName());
            throw new UploadUnauthorized("The file should have media type.");
        }
        String mediaType = mediaEntity.getType() + "/" + mediaEntity.getSubType();
        try {
            detectedMediaType = TIKA.detect(mediaEntity.getData(), mediaEntity.getFileName());
        }
        catch (IllegalStateException e) {
            log.error("Unable to determine file type for '{}'", (Object)mediaEntity.getFileName(), (Object)e);
            throw new UploadUnauthorized("Unable to determine file type.");
        }
        log.debug("File '{}': declared type='{}', detected type='{}'", new Object[]{mediaEntity.getFileName(), mediaType, detectedMediaType});
        (mediaType.equals(detectedMediaType) ? Set.of(mediaType) : Set.of(mediaType, detectedMediaType)).forEach(type -> {
            if (this.isForbidden((String)type)) {
                log.warn("Forbidden file type '{}' detected for file '{}'", type, (Object)mediaEntity.getFileName());
                throw new UploadUnauthorized("Unsupported file type: " + type + ". Uploading this type of file is not allowed.");
            }
        });
        if (("application/pdf".equals(mediaType) || "application/pdf".equals(detectedMediaType)) && !this.isAcceptablePDF(mediaEntity)) {
            throw new UploadUnauthorized("This pdf use unallowed features.");
        }
    }

    private boolean isForbidden(String mediaType) {
        if (mediaType == null) {
            return true;
        }
        return FORBIDDEN_TYPES.contains(mediaType.toLowerCase());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAcceptablePDF(MediaEntity media) {
        try (PDDocument document = Loader.loadPDF((byte[])media.getData());){
            boolean isForbiddenAction;
            if (document.getNumberOfPages() == 0) {
                log.warn("No pages found for PDF file {}.", (Object)media.getFileName());
                boolean bl = false;
                return bl;
            }
            if (document.isEncrypted()) {
                log.warn("PDF file {} should not be encrypted.", (Object)media.getFileName());
                boolean bl = false;
                return bl;
            }
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            if (catalog.getNames() != null && catalog.getNames().getJavaScript() != null) {
                log.warn("PDF file {} should not use Javascript.", (Object)media.getFileName());
                boolean bl = false;
                return bl;
            }
            PDDestinationOrAction openAction = catalog.getOpenAction();
            boolean bl = isForbiddenAction = openAction instanceof PDActionJavaScript || openAction instanceof PDActionLaunch || openAction instanceof PDActionImportData || openAction instanceof PDActionSubmitForm;
            if (isForbiddenAction) {
                log.warn("PDF file {} use forbidden open action.", (Object)media.getFileName());
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = true;
            return bl3;
        }
        catch (IOException e) {
            log.error("Unable to read the PDF file {}.", (Object)media.getFileName(), (Object)e);
            return false;
        }
    }
}

