/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.api.domain_service.cockpit.DeployModelToApiDomainService;
import io.gravitee.apim.core.api.exception.InvalidPathsException;
import io.gravitee.apim.core.api.use_case.cockpit.DeployModelToApiCreateUseCase;
import io.gravitee.apim.core.api.use_case.cockpit.DeployModelToApiUpdateUseCase;
import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.designer.DeployModelCommand;
import io.gravitee.cockpit.api.command.v1.designer.DeployModelCommandPayload;
import io.gravitee.cockpit.api.command.v1.designer.DeployModelReply;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntityResult;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.cockpit.model.DeploymentMode;
import io.gravitee.rest.api.service.cockpit.services.ApiServiceCockpit;
import io.gravitee.rest.api.service.cockpit.services.CockpitApiPermissionChecker;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.SecurityContextHelper;
import io.gravitee.rest.api.service.exceptions.EnvironmentNotFoundException;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeployModelCommandHandler
implements CommandHandler<DeployModelCommand, DeployModelReply> {
    private final Logger logger = LoggerFactory.getLogger(DeployModelCommandHandler.class);
    private final ApiSearchService apiSearchService;
    private final ApiServiceCockpit cockpitApiService;
    private final CockpitApiPermissionChecker permissionChecker;
    private final UserService userService;
    private final EnvironmentService environmentService;
    private final DeployModelToApiCreateUseCase deployModelToApiCreateUseCase;
    private final DeployModelToApiUpdateUseCase deployModelToApiUpdateUseCase;

    public String supportType() {
        return CockpitCommandType.DEPLOY_MODEL.name();
    }

    public Single<DeployModelReply> handle(DeployModelCommand command) {
        DeployModelCommandPayload payload = (DeployModelCommandPayload)command.getPayload();
        String apiCrossId = payload.modelId();
        String userId = payload.userId();
        String swaggerDefinition = payload.swaggerDefinition();
        String environmentId = payload.environmentId();
        DeploymentMode mode = DeploymentMode.fromDeployModelPayload(payload);
        List labels = payload.labels();
        ExecutionContext executionContext = new ExecutionContext(this.getEnvironment(environmentId));
        UserEntity user = this.userService.findBySource(executionContext.getOrganizationId(), "cockpit", userId, true);
        Optional<String> optApiId = this.apiSearchService.findIdByEnvironmentIdAndCrossId(executionContext.getEnvironmentId(), apiCrossId);
        try {
            SecurityContextHelper.authenticateAs(user);
            AuditInfo audit = AuditInfo.builder().organizationId(executionContext.getOrganizationId()).environmentId(executionContext.getEnvironmentId()).actor(AuditActor.builder().userId(user.getId()).userSource(user.getSource()).userSourceId(user.getSourceId()).build()).build();
            if (optApiId.isPresent()) {
                String apiId = optApiId.get();
                Optional<String> message = this.permissionChecker.checkUpdatePermission(executionContext, user.getId(), executionContext.getEnvironmentId(), apiId, mode);
                return message.map(s -> Single.just((Object)new DeployModelReply(command.getId(), s))).orElseGet(() -> {
                    Api api = this.apiSearchService.findRepositoryApiById(executionContext, apiId);
                    if (api.getDefinitionVersion() == DefinitionVersion.V2) {
                        return this.updateV2Api(command, apiId, executionContext, user, mode, swaggerDefinition, labels);
                    }
                    this.deployModelToApiUpdateUseCase.execute(new DeployModelToApiUpdateUseCase.Input(swaggerDefinition, audit, apiId, apiCrossId, this.fromDeploymentModel(mode), labels));
                    return Single.just((Object)new DeployModelReply(command.getId()));
                });
            }
            Optional<String> message = this.permissionChecker.checkCreatePermission(executionContext, user.getId(), executionContext.getEnvironmentId(), mode);
            return message.map(error -> Single.just((Object)new DeployModelReply(command.getId(), error))).orElseGet(() -> {
                this.deployModelToApiCreateUseCase.execute(new DeployModelToApiCreateUseCase.Input(swaggerDefinition, audit, apiCrossId, this.fromDeploymentModel(mode), labels));
                return Single.just((Object)new DeployModelReply(command.getId()));
            });
        }
        catch (InvalidPathsException ipe) {
            this.logger.error("Context path already used, API [crossId: {}] can be imported", (Object)apiCrossId, (Object)ipe);
            return Single.just((Object)new DeployModelReply(command.getId(), "Failed to import API [context path not available]."));
        }
        catch (Exception e) {
            this.logger.error("Error occurred when importing API [crossId: {}]", (Object)apiCrossId, (Object)e);
            return Single.just((Object)new DeployModelReply(command.getId(), "Error occurred when importing API"));
        }
    }

    private DeployModelToApiDomainService.Mode fromDeploymentModel(DeploymentMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case DeploymentMode.API_DOCUMENTED -> DeployModelToApiDomainService.Mode.DOCUMENTED;
            case DeploymentMode.API_MOCKED -> DeployModelToApiDomainService.Mode.MOCKED;
            case DeploymentMode.API_PUBLISHED -> DeployModelToApiDomainService.Mode.PUBLISHED;
        };
    }

    @NotNull
    private Single<DeployModelReply> updateV2Api(DeployModelCommand command, String apiId, ExecutionContext executionContext, UserEntity user, DeploymentMode mode, String swaggerDefinition, List<String> labels) {
        ApiEntityResult result = this.cockpitApiService.updateApi(executionContext, apiId, user.getId(), swaggerDefinition, executionContext.getEnvironmentId(), mode, labels);
        this.logger.info("API [id: {} / crossId: {}] v2 updated.", (Object)result.getApi().getId(), (Object)result.getApi().getCrossId());
        return Single.just((Object)new DeployModelReply(command.getId()));
    }

    private EnvironmentEntity getEnvironment(String environmentId) {
        try {
            return this.environmentService.findByCockpitId(environmentId);
        }
        catch (EnvironmentNotFoundException e) {
            return this.environmentService.findById(environmentId);
        }
    }

    @Generated
    public DeployModelCommandHandler(ApiSearchService apiSearchService, ApiServiceCockpit cockpitApiService, CockpitApiPermissionChecker permissionChecker, UserService userService, EnvironmentService environmentService, DeployModelToApiCreateUseCase deployModelToApiCreateUseCase, DeployModelToApiUpdateUseCase deployModelToApiUpdateUseCase) {
        this.apiSearchService = apiSearchService;
        this.cockpitApiService = cockpitApiService;
        this.permissionChecker = permissionChecker;
        this.userService = userService;
        this.environmentService = environmentService;
        this.deployModelToApiCreateUseCase = deployModelToApiCreateUseCase;
        this.deployModelToApiUpdateUseCase = deployModelToApiUpdateUseCase;
    }
}

