/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.portal_page;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.portal_page.model.PortalPageContent;
import io.gravitee.apim.core.portal_page.model.PortalPageContentId;
import io.gravitee.apim.core.portal_page.query_service.PortalPageContentQueryService;
import io.gravitee.apim.infra.adapter.PortalPageContentAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalPageContentRepository;
import java.util.Optional;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PortalPageContentQueryServiceImpl
implements PortalPageContentQueryService {
    private final PortalPageContentRepository portalPageContentRepository;
    private final PortalPageContentAdapter portalPageContentAdapter = PortalPageContentAdapter.INSTANCE;

    public PortalPageContentQueryServiceImpl(@Lazy PortalPageContentRepository portalPageContentRepository) {
        this.portalPageContentRepository = portalPageContentRepository;
    }

    @Override
    public Optional<PortalPageContent> findById(PortalPageContentId id) {
        try {
            return this.portalPageContentRepository.findById((Object)id.json()).map(this.portalPageContentAdapter::toEntity);
        }
        catch (TechnicalException e) {
            String errorMessage = String.format("An error occurred while finding portal page content by id %s", id.json());
            throw new TechnicalDomainException(errorMessage, e);
        }
    }
}

