/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.analytics_engine.processors;

import io.gravitee.apim.core.analytics_engine.domain_service.FilterPreProcessor;
import io.gravitee.apim.core.analytics_engine.model.Filter;
import io.gravitee.apim.core.analytics_engine.model.FilterSpec;
import io.gravitee.apim.core.analytics_engine.model.MetricsContext;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.v4.ApiAuthorizationService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.core.context.SecurityContextHolder;

public class ManagementFilterPreProcessor
implements FilterPreProcessor {
    private static final String ORGANIZATION_ADMIN = RoleScope.ORGANIZATION.name() + ":" + SystemRole.ADMIN.name();
    private final ApiAuthorizationService apiAuthorizationService;
    private final ApiRepository apiRepository;

    @Override
    public MetricsContext buildFilters(MetricsContext context) {
        Map<String, String> userApis = this.findUserApis(context.auditInfo().organizationId(), context.auditInfo().environmentId(), context.auditInfo().actor().userId());
        Set<String> userApisIds = userApis.keySet();
        Filter permissionsFilter = new Filter(FilterSpec.Name.API, FilterSpec.Operator.IN, userApisIds);
        return context.withFilters(List.of(permissionsFilter)).withApiNamesById(userApis);
    }

    private static Map<String, String> mapApiIdsToNames(Collection<Api> apis) {
        return apis.stream().collect(Collectors.toMap(Api::getId, Api::getName));
    }

    protected boolean isAdmin() {
        return SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().anyMatch(grantedAuthority -> {
            String authority = grantedAuthority.getAuthority();
            return authority.equalsIgnoreCase(ORGANIZATION_ADMIN);
        });
    }

    private Map<String, String> findUserApis(String organizationId, String environmentId, String userId) {
        ExecutionContext executionContext = new ExecutionContext(organizationId, environmentId);
        ApiCriteria.Builder apiCriteriaBuilder = new ApiCriteria.Builder().environmentId(environmentId);
        if (!this.isAdmin()) {
            Set<String> userApiIds = this.apiAuthorizationService.findApiIdsByUserId(executionContext, userId, null, true);
            apiCriteriaBuilder.ids(userApiIds);
        }
        List apis = this.apiRepository.search(apiCriteriaBuilder.build(), ApiFieldFilter.defaultFields());
        return ManagementFilterPreProcessor.mapApiIdsToNames(apis);
    }

    @Generated
    public ManagementFilterPreProcessor(ApiAuthorizationService apiAuthorizationService, ApiRepository apiRepository) {
        this.apiAuthorizationService = apiAuthorizationService;
        this.apiRepository = apiRepository;
    }
}

