/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.plan;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PlanCrudServiceImpl
implements PlanCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanCrudServiceImpl.class);
    private final PlanRepository planRepository;

    public PlanCrudServiceImpl(@Lazy PlanRepository planRepository) {
        this.planRepository = planRepository;
    }

    @Override
    public Plan getById(String planId) {
        try {
            log.debug("Get plan by id : {}", (Object)planId);
            return this.planRepository.findById((Object)planId).map(PlanAdapter.INSTANCE::fromRepository).orElseThrow(() -> new PlanNotFoundException(planId));
        }
        catch (TechnicalException ex) {
            throw new TechnicalDomainException(String.format("An error occurred while trying to get a plan by id: %s", planId), ex);
        }
    }

    @Override
    public Optional<Plan> findById(String planId) {
        try {
            log.debug("Find a plan by id : {}", (Object)planId);
            return this.planRepository.findById((Object)planId).map(PlanAdapter.INSTANCE::fromRepository);
        }
        catch (TechnicalException ex) {
            throw new TechnicalDomainException(String.format("An error occurred while trying to find a plan by id: %s", planId), ex);
        }
    }

    @Override
    public List<Plan> findByIds(List<String> planIds) {
        log.debug("Find all plan by ids : {}", planIds);
        try {
            return this.planRepository.findByIdIn(planIds).stream().map(PlanAdapter.INSTANCE::fromRepository).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurred while trying to find all plan by ids %s", planIds), e);
        }
    }

    @Override
    public void updateCrossIds(List<Plan> plans) {
        log.debug("Update plans cross IDs : {}", plans);
        try {
            this.planRepository.updateCrossIds(plans.stream().map(PlanAdapter.INSTANCE::toRepository).toList());
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurred while trying to update plans cross IDs %s", plans), e);
        }
    }

    @Override
    public Collection<Plan> findByApiId(String apiId) {
        try {
            log.debug("Find a plan by API id : {}", (Object)apiId);
            return CollectionUtils.stream(this.planRepository.findByApi(apiId)).map(PlanAdapter.INSTANCE::fromRepository).toList();
        }
        catch (TechnicalException ex) {
            throw new TechnicalDomainException(String.format("An error occurred while trying to find a plan by id: %s", apiId), ex);
        }
    }

    @Override
    public Plan create(Plan plan) {
        try {
            io.gravitee.repository.management.model.Plan result = (io.gravitee.repository.management.model.Plan)this.planRepository.create((Object)PlanAdapter.INSTANCE.toRepository(plan));
            return PlanAdapter.INSTANCE.fromRepository(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurred while trying to create the plan: " + plan.getId(), e);
        }
    }

    @Override
    public Plan update(Plan plan) {
        try {
            io.gravitee.repository.management.model.Plan result = (io.gravitee.repository.management.model.Plan)this.planRepository.update((Object)PlanAdapter.INSTANCE.toRepository(plan));
            return PlanAdapter.INSTANCE.fromRepository(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurred while trying to update the plan: " + plan.getId(), e);
        }
    }

    @Override
    public void delete(String planId) {
        try {
            this.planRepository.delete((Object)planId);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurred while trying to delete the plan: " + planId, e);
        }
    }
}

