/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_page.exception.InvalidPortalNavigationItemDataException;
import io.gravitee.apim.core.portal_page.exception.PageContentNotFoundException;
import io.gravitee.apim.core.portal_page.exception.PortalNavigationItemNotFoundException;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemType;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemViewerContext;
import io.gravitee.apim.core.portal_page.model.PortalNavigationPage;
import io.gravitee.apim.core.portal_page.model.PortalPageContent;
import io.gravitee.apim.core.portal_page.query_service.PortalNavigationItemsQueryService;
import io.gravitee.apim.core.portal_page.query_service.PortalPageContentQueryService;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class GetPortalPageContentByNavigationIdUseCase {
    private final PortalNavigationItemsQueryService portalNavigationItemsQueryService;
    private final PortalPageContentQueryService portalPageContentQueryService;

    public Output execute(Input input) {
        PortalNavigationItem portalNavigationItem = Optional.ofNullable(this.portalNavigationItemsQueryService.findByIdAndEnvironmentId(input.environmentId(), PortalNavigationItemId.of(input.portalNavigationItemId()))).orElseThrow(() -> new PortalNavigationItemNotFoundException(input.portalNavigationItemId()));
        input.viewerContext().validateAccess(portalNavigationItem);
        if (!(portalNavigationItem instanceof PortalNavigationPage)) {
            throw InvalidPortalNavigationItemDataException.typeMismatch(PortalNavigationItemType.PAGE.name(), portalNavigationItem.getType().name());
        }
        PortalNavigationPage page = (PortalNavigationPage)portalNavigationItem;
        PortalPageContent portalPageContent = this.portalPageContentQueryService.findById(page.getPortalPageContentId()).orElseThrow(() -> new PageContentNotFoundException(page.getPortalPageContentId().toString()));
        return new Output(portalPageContent, portalNavigationItem);
    }

    @Generated
    public GetPortalPageContentByNavigationIdUseCase(PortalNavigationItemsQueryService portalNavigationItemsQueryService, PortalPageContentQueryService portalPageContentQueryService) {
        this.portalNavigationItemsQueryService = portalNavigationItemsQueryService;
        this.portalPageContentQueryService = portalPageContentQueryService;
    }

    public record Input(String portalNavigationItemId, String environmentId, PortalNavigationItemViewerContext viewerContext) {
    }

    public record Output(PortalPageContent portalPageContent, PortalNavigationItem portalNavigationItem) {
    }
}

