/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_page.domain_service.PortalNavigationItemDomainService;
import io.gravitee.apim.core.portal_page.domain_service.PortalNavigationItemValidatorService;
import io.gravitee.apim.core.portal_page.model.CreatePortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import lombok.Generated;

@UseCase
public class CreatePortalNavigationItemUseCase {
    private final PortalNavigationItemDomainService domainService;
    private final PortalNavigationItemValidatorService validatorService;

    public Output execute(Input input) {
        CreatePortalNavigationItem itemToCreate = input.item();
        String organizationId = input.organizationId();
        String environmentId = input.environmentId();
        this.validatorService.validate(itemToCreate, environmentId);
        return new Output(this.domainService.create(organizationId, environmentId, itemToCreate));
    }

    @Generated
    public CreatePortalNavigationItemUseCase(PortalNavigationItemDomainService domainService, PortalNavigationItemValidatorService validatorService) {
        this.domainService = domainService;
        this.validatorService = validatorService;
    }

    public record Input(String organizationId, String environmentId, CreatePortalNavigationItem item) {
    }

    public record Output(PortalNavigationItem item) {
    }
}

