/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_page.crud_service.PortalPageContentCrudService;
import io.gravitee.apim.core.portal_page.domain_service.PortalNavigationItemDomainService;
import io.gravitee.apim.core.portal_page.model.CreatePortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.GraviteeMarkdownPageContent;
import io.gravitee.apim.core.portal_page.model.PortalArea;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemType;
import io.gravitee.apim.core.portal_page.model.PortalPageContent;
import io.gravitee.apim.core.portal_page.model.PortalPageContentId;
import java.io.InputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class CreateDefaultPortalNavigationItemsUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateDefaultPortalNavigationItemsUseCase.class);
    private static final String GETTING_STARTED_PATH = "portal-getting-started-page-content.md";
    private static final String AUTHENTICATION_PATH = "portal-authentication-page-content.md";
    private static final String FIRST_API_CALL_PATH = "portal-first-api-call-page-content.md";
    private static final String DOCS_URL = "https://documentation.gravitee.io/apim/developer-portal/new-developer-portal";
    private static final String HOMEPAGE_CONTENT_PATH = "default-portal-homepage-content.md";
    private final PortalNavigationItemDomainService portalNavigationItemDomainService;
    private final PortalPageContentCrudService pageContentCrudService;

    public void execute(String organizationId, String environmentId) {
        PortalNavigationItem folderGuides = this.createPortalFolder("Guides", organizationId, environmentId, PortalArea.TOP_NAVBAR, null);
        PortalPageContent contentGettingStarted = this.createPortalPageContent(organizationId, environmentId, GETTING_STARTED_PATH);
        this.createPortalPage("Getting started", organizationId, environmentId, PortalArea.TOP_NAVBAR, contentGettingStarted.getId(), folderGuides.getId());
        PortalNavigationItem folderCoreConcepts = this.createPortalFolder("Core concepts", organizationId, environmentId, PortalArea.TOP_NAVBAR, folderGuides.getId());
        PortalPageContent contentAuthentication = this.createPortalPageContent(organizationId, environmentId, AUTHENTICATION_PATH);
        this.createPortalPage("Authentication", organizationId, environmentId, PortalArea.TOP_NAVBAR, contentAuthentication.getId(), folderCoreConcepts.getId());
        PortalPageContent contentFirstApiCall = this.createPortalPageContent(organizationId, environmentId, FIRST_API_CALL_PATH);
        this.createPortalPage("Making your first API call", organizationId, environmentId, PortalArea.TOP_NAVBAR, contentFirstApiCall.getId(), folderCoreConcepts.getId());
        this.createPortalLink("Docs", organizationId, environmentId, DOCS_URL, PortalArea.TOP_NAVBAR, null);
        PortalPageContent contentHomePage = this.createPortalPageContent(organizationId, environmentId, HOMEPAGE_CONTENT_PATH);
        this.createPortalPage("Home Page", organizationId, environmentId, PortalArea.HOMEPAGE, contentHomePage.getId(), null);
    }

    private PortalNavigationItem createPortalFolder(String title, String organizationId, String environmentId, PortalArea area, PortalNavigationItemId parentId) {
        CreatePortalNavigationItem createItem = this.buildCommonItem(title, parentId, area);
        createItem.setType(PortalNavigationItemType.FOLDER);
        return this.portalNavigationItemDomainService.create(organizationId, environmentId, createItem);
    }

    private PortalNavigationItem createPortalPage(String title, String organizationId, String environmentId, PortalArea area, PortalPageContentId portalPageContentId, PortalNavigationItemId parentId) {
        CreatePortalNavigationItem createItem = this.buildCommonItem(title, parentId, area);
        createItem.setType(PortalNavigationItemType.PAGE);
        createItem.setPortalPageContentId(portalPageContentId);
        return this.portalNavigationItemDomainService.create(organizationId, environmentId, createItem);
    }

    private PortalNavigationItem createPortalLink(String title, String organizationId, String environmentId, String url, PortalArea area, PortalNavigationItemId parentId) {
        CreatePortalNavigationItem createItem = this.buildCommonItem(title, parentId, area);
        createItem.setType(PortalNavigationItemType.LINK);
        createItem.setUrl(url);
        return this.portalNavigationItemDomainService.create(organizationId, environmentId, createItem);
    }

    private CreatePortalNavigationItem buildCommonItem(String title, PortalNavigationItemId parentId, PortalArea area) {
        return CreatePortalNavigationItem.builder().title(title).area(area).parentId(parentId).published(true).build();
    }

    private PortalPageContent createPortalPageContent(String organizationId, String environmentId, String contentPath) {
        GraviteeMarkdownPageContent content = new GraviteeMarkdownPageContent(PortalPageContentId.random(), organizationId, environmentId, this.loadContent(contentPath));
        return this.pageContentCrudService.create(content);
    }

    private String loadContent(String contentPath) {
        String string;
        block9: {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format("templates/%s", contentPath));
            try {
                if (is == null) {
                    throw new IllegalStateException(String.format("Could not load default portal page template for %s", contentPath));
                }
                string = new String(is.readAllBytes());
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not load default portal page template", e);
                }
            }
            is.close();
        }
        return string;
    }

    @Generated
    public CreateDefaultPortalNavigationItemsUseCase(PortalNavigationItemDomainService portalNavigationItemDomainService, PortalPageContentCrudService pageContentCrudService) {
        this.portalNavigationItemDomainService = portalNavigationItemDomainService;
        this.pageContentCrudService = pageContentCrudService;
    }
}

