/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.portal_page.crud_service.PortalNavigationItemCrudService;
import io.gravitee.apim.core.portal_page.crud_service.PortalPageContentCrudService;
import io.gravitee.apim.core.portal_page.model.CreatePortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalArea;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemType;
import io.gravitee.apim.core.portal_page.model.PortalNavigationPage;
import io.gravitee.apim.core.portal_page.model.PortalPageContent;
import io.gravitee.apim.core.portal_page.model.PortalPageContentId;
import io.gravitee.apim.core.portal_page.model.UpdatePortalNavigationItem;
import io.gravitee.apim.core.portal_page.query_service.PortalNavigationItemsQueryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;

@DomainService
public class PortalNavigationItemDomainService {
    private final PortalNavigationItemCrudService crudService;
    private final PortalNavigationItemsQueryService queryService;
    private final PortalPageContentCrudService pageContentCrudService;

    public PortalNavigationItem create(String organizationId, String environmentId, CreatePortalNavigationItem createPortalNavigationItem) {
        int sanitizedOrder = this.sanitizeOrderForInsertion(createPortalNavigationItem.getParentId(), environmentId, createPortalNavigationItem.getArea(), createPortalNavigationItem.getOrder());
        createPortalNavigationItem.setOrder(sanitizedOrder);
        if (createPortalNavigationItem.getType() == PortalNavigationItemType.PAGE && createPortalNavigationItem.getPortalPageContentId() == null) {
            PortalPageContent defaultPageContent = this.pageContentCrudService.createDefault(organizationId, environmentId);
            createPortalNavigationItem.setPortalPageContentId(defaultPageContent.getId());
        }
        PortalNavigationItem portalNavigationItem = this.crudService.create(PortalNavigationItem.from(createPortalNavigationItem, organizationId, environmentId));
        this.retrieveSiblingItems(portalNavigationItem.getParentId(), portalNavigationItem.getEnvironmentId(), createPortalNavigationItem.getArea()).stream().filter(item -> !Objects.equals(item.getId(), portalNavigationItem.getId())).filter(sibling -> sibling.getOrder() >= portalNavigationItem.getOrder()).forEach(followingSibling -> {
            followingSibling.setOrder(followingSibling.getOrder() + 1);
            this.crudService.update((PortalNavigationItem)followingSibling);
        });
        return portalNavigationItem;
    }

    private List<PortalNavigationItem> retrieveSiblingItems(PortalNavigationItemId parentId, String environmentId, PortalArea area) {
        return parentId != null ? this.queryService.findByParentIdAndEnvironmentId(environmentId, parentId) : this.queryService.findTopLevelItemsByEnvironmentIdAndPortalArea(environmentId, area);
    }

    public void delete(PortalNavigationItem item) {
        PortalPageContentId contentId = item instanceof PortalNavigationPage ? ((PortalNavigationPage)item).getPortalPageContentId() : null;
        PortalNavigationItemId parentId = item.getParentId();
        Integer deletedOrder = item.getOrder();
        List<PortalNavigationItem> siblings = this.retrieveSiblingItems(parentId, item.getEnvironmentId(), item.getArea());
        List<PortalNavigationItem> siblingsToUpdate = siblings.stream().filter(sibling -> !sibling.getId().equals(item.getId())).filter(sibling -> sibling.getOrder() > deletedOrder).toList();
        siblingsToUpdate.forEach(sibling -> sibling.setOrder(sibling.getOrder() - 1));
        if (contentId != null) {
            this.pageContentCrudService.delete(contentId);
        }
        this.crudService.delete(item.getId());
        siblingsToUpdate.forEach(this.crudService::update);
    }

    public PortalNavigationItem update(UpdatePortalNavigationItem toUpdate, PortalNavigationItem originalItem) {
        Integer originalOrder = originalItem.getOrder();
        PortalNavigationItemId originalParentId = originalItem.getParentId();
        boolean isMoveToNewParent = !Objects.equals(originalParentId, toUpdate.getParentId());
        int sanitizedOrder = isMoveToNewParent ? this.sanitizeOrderForInsertion(toUpdate.getParentId(), originalItem.getEnvironmentId(), originalItem.getArea(), toUpdate.getOrder()) : this.sanitizeOrderForReordering(toUpdate.getParentId(), originalItem.getEnvironmentId(), originalItem.getArea(), toUpdate.getOrder());
        toUpdate.setOrder(sanitizedOrder);
        originalItem.update(toUpdate);
        PortalNavigationItem updatedItem = this.crudService.update(originalItem);
        ArrayList<PortalNavigationItem> siblingsToUpdate = new ArrayList<PortalNavigationItem>();
        if (!Objects.equals(originalParentId, updatedItem.getParentId())) {
            siblingsToUpdate.addAll(this.reorderDestinationSiblingsOnInsertion(updatedItem));
            siblingsToUpdate.addAll(this.reorderOriginSiblings(originalOrder, updatedItem, originalParentId));
        } else if (!Objects.equals(originalOrder, updatedItem.getOrder())) {
            siblingsToUpdate.addAll(this.reorderDestinationSiblings(originalOrder, updatedItem));
        }
        siblingsToUpdate.forEach(this.crudService::update);
        return updatedItem;
    }

    private int sanitizeOrderForReordering(PortalNavigationItemId parentId, String environmentId, PortalArea area, Integer order) {
        List<PortalNavigationItem> siblingItems = this.retrieveSiblingItems(parentId, environmentId, area);
        int maxOrder = Math.max(0, siblingItems.size() - 1);
        if (Objects.isNull(order)) {
            return maxOrder;
        }
        return Math.min(order, maxOrder);
    }

    private int sanitizeOrderForInsertion(PortalNavigationItemId parentId, String environmentId, PortalArea area, Integer order) {
        int newMaxOrder = this.retrieveSiblingItems(parentId, environmentId, area).size();
        if (Objects.isNull(order)) {
            return newMaxOrder;
        }
        return Math.min(order, newMaxOrder);
    }

    private List<PortalNavigationItem> reorderOriginSiblings(Integer originalOrder, PortalNavigationItem updatedItem, PortalNavigationItemId originalParentId) {
        return this.retrieveSiblingItems(originalParentId, updatedItem.getEnvironmentId(), updatedItem.getArea()).stream().filter(sibling -> sibling.getOrder() > originalOrder).peek(sibling -> sibling.setOrder(sibling.getOrder() - 1)).toList();
    }

    private List<PortalNavigationItem> reorderDestinationSiblingsOnInsertion(PortalNavigationItem updatedItem) {
        return this.retrieveSiblingItems(updatedItem.getParentId(), updatedItem.getEnvironmentId(), updatedItem.getArea()).stream().filter(sibling -> !Objects.equals(sibling.getId(), updatedItem.getId()) && sibling.getOrder() >= updatedItem.getOrder()).peek(sibling -> sibling.setOrder(sibling.getOrder() + 1)).toList();
    }

    private List<PortalNavigationItem> reorderDestinationSiblings(Integer originalOrder, PortalNavigationItem updatedItem) {
        Predicate<PortalNavigationItem> shouldBeDecremented = sibling -> sibling.getOrder() > originalOrder && sibling.getOrder() <= updatedItem.getOrder();
        Predicate<PortalNavigationItem> shouldBeIncremented = sibling -> sibling.getOrder() >= updatedItem.getOrder() && sibling.getOrder() < originalOrder;
        return this.retrieveSiblingItems(updatedItem.getParentId(), updatedItem.getEnvironmentId(), updatedItem.getArea()).stream().filter(sibling -> !Objects.equals(sibling.getId(), updatedItem.getId()) && (shouldBeDecremented.test((PortalNavigationItem)sibling) || shouldBeIncremented.test((PortalNavigationItem)sibling))).peek(sibling -> {
            if (shouldBeDecremented.test((PortalNavigationItem)sibling)) {
                sibling.setOrder(sibling.getOrder() - 1);
            } else if (shouldBeIncremented.test((PortalNavigationItem)sibling)) {
                sibling.setOrder(sibling.getOrder() + 1);
            }
        }).toList();
    }

    @Generated
    public PortalNavigationItemDomainService(PortalNavigationItemCrudService crudService, PortalNavigationItemsQueryService queryService, PortalPageContentCrudService pageContentCrudService) {
        this.crudService = crudService;
        this.queryService = queryService;
        this.pageContentCrudService = pageContentCrudService;
    }
}

