/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.flow.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.exception.NativeApiWithMultipleFlowsException;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.flow.exception.InvalidFlowException;
import io.gravitee.apim.core.plugin.model.PlatformPlugin;
import io.gravitee.apim.core.plugin.query_service.EntrypointPluginQueryService;
import io.gravitee.apim.core.policy.domain_service.PolicyValidationDomainService;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.flow.AbstractFlow;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.selector.ChannelSelector;
import io.gravitee.definition.model.v4.flow.selector.HttpSelector;
import io.gravitee.definition.model.v4.flow.selector.SelectorType;
import io.gravitee.definition.model.v4.flow.step.Step;
import io.gravitee.definition.model.v4.nativeapi.NativeFlow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DomainService
public class FlowValidationDomainService {
    private static final String PATH_PARAM_PREFIX = ":";
    private static final String PATH_SEPARATOR = "/";
    private static final Pattern SEPARATOR_SPLITTER = Pattern.compile("/");
    private static final Pattern PARAM_PATTERN = Pattern.compile(":\\w*");
    private final PolicyValidationDomainService policyValidationDomainService;
    private final EntrypointPluginQueryService entrypointConnectorPluginService;
    private static final Map<ApiType, Function<Flow, Optional<String>>> PATH_EXTRACTOR = Map.of(ApiType.PROXY, flow -> flow.selectorByType(SelectorType.HTTP).stream().map(selector -> ((HttpSelector)selector).getPath()).findFirst(), ApiType.MESSAGE, flow -> flow.selectorByType(SelectorType.CHANNEL).stream().map(selector -> ((ChannelSelector)selector).getChannel()).findFirst(), ApiType.MCP_PROXY, flow -> Optional.empty(), ApiType.LLM_PROXY, flow -> flow.selectorByType(SelectorType.HTTP).stream().map(selector -> ((HttpSelector)selector).getPath()).findFirst());

    public FlowValidationDomainService(PolicyValidationDomainService policyValidationDomainService, EntrypointPluginQueryService entrypointConnectorPluginService) {
        this.policyValidationDomainService = policyValidationDomainService;
        this.entrypointConnectorPluginService = entrypointConnectorPluginService;
    }

    public List<Flow> validateAndSanitizeHttpV4(ApiType apiType, List<Flow> flows) {
        if (flows != null) {
            flows.forEach(flow -> {
                this.checkDuplicatedSelectors((Flow)flow);
                this.checkSelectorsForType(apiType, (Flow)flow);
                List<Step> steps = Stream.of(flow.getRequest(), flow.getResponse(), flow.getPublish(), flow.getSubscribe()).filter(Objects::nonNull).flatMap(Collection::stream).toList();
                this.checkPolicyConfiguration(steps);
            });
        }
        return flows;
    }

    public List<NativeFlow> validateAndSanitizeNativeV4(List<NativeFlow> flows) {
        if (flows != null) {
            if (flows.size() > 1) {
                throw new NativeApiWithMultipleFlowsException();
            }
            flows.forEach(flow -> {
                List<Step> steps = Stream.of(flow.getInteract(), flow.getConnect(), flow.getPublish(), flow.getSubscribe()).filter(Objects::nonNull).flatMap(Collection::stream).toList();
                this.checkPolicyConfiguration(steps);
            });
        }
        return flows;
    }

    private void checkSelectorsForType(ApiType apiType, Flow flow) {
        if (flow.getSelectors() != null) {
            Set<String> invalidSelectors;
            if (ApiType.PROXY == apiType || ApiType.LLM_PROXY == apiType) {
                Set<String> invalidSelectors2 = flow.getSelectors().stream().filter(selector -> selector.getType() != SelectorType.HTTP && selector.getType() != SelectorType.CONDITION).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet());
                if (!invalidSelectors2.isEmpty()) {
                    throw InvalidFlowException.invalidSelector(flow.getName(), apiType, invalidSelectors2);
                }
            } else if (ApiType.MESSAGE == apiType) {
                Set<String> invalidSelectors3 = flow.getSelectors().stream().filter(selector -> selector.getType() != SelectorType.CHANNEL && selector.getType() != SelectorType.CONDITION).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet());
                if (!invalidSelectors3.isEmpty()) {
                    throw InvalidFlowException.invalidSelector(flow.getName(), apiType, invalidSelectors3);
                }
                this.checkChannelAsyncEntrypoint(flow);
            } else if (ApiType.MCP_PROXY == apiType && !(invalidSelectors = flow.getSelectors().stream().filter(selector -> selector.getType() != SelectorType.MCP && selector.getType() != SelectorType.CONDITION).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet())).isEmpty()) {
                throw InvalidFlowException.invalidSelector(flow.getName(), apiType, invalidSelectors);
            }
        }
    }

    private void checkChannelAsyncEntrypoint(Flow flow) {
        ChannelSelector channelSelector;
        Optional<ChannelSelector> channelSelectorOpt = flow.getSelectors().stream().filter(selector -> selector.getType() == SelectorType.CHANNEL).map(ChannelSelector.class::cast).findFirst();
        if (channelSelectorOpt.isPresent() && (channelSelector = channelSelectorOpt.get()).getEntrypoints() != null) {
            Set asyncEntrypoints = this.entrypointConnectorPluginService.findBySupportedApi(ApiType.MESSAGE).stream().map(PlatformPlugin::getId).collect(Collectors.toSet());
            Set<String> invalidEntrypoints = channelSelector.getEntrypoints().stream().filter(entrypointId -> !asyncEntrypoints.contains(entrypointId)).collect(Collectors.toSet());
            if (!invalidEntrypoints.isEmpty()) {
                throw InvalidFlowException.invalidEntrypoint(flow.getName(), invalidEntrypoints);
            }
        }
    }

    private void checkPolicyConfiguration(List<Step> steps) {
        steps.stream().filter(step -> step != null && step.getPolicy() != null && step.getConfiguration() != null).forEach(step -> step.setConfiguration(this.policyValidationDomainService.validateAndSanitizeConfiguration(step.getPolicy(), step.getConfiguration())));
    }

    private void checkDuplicatedSelectors(Flow flow) {
        if (flow.getSelectors() != null) {
            HashSet seenSelectors = new HashSet();
            Set<String> duplicatedSelectors = flow.getSelectors().stream().filter(e -> !seenSelectors.add(e)).map(selector -> selector.getType().getLabel()).collect(Collectors.toSet());
            if (!duplicatedSelectors.isEmpty()) {
                throw InvalidFlowException.duplicatedSelector(flow.getName(), duplicatedSelectors);
            }
        }
    }

    public void validatePathParameters(ApiType apiType, Stream<Flow> apiFlows, Stream<Flow> planFlows) {
        apiFlows = apiFlows == null ? Stream.empty() : apiFlows;
        planFlows = planFlows == null ? Stream.empty() : planFlows;
        Stream<Flow> flowsWithPathParam = this.filterFlowsWithPathParam(apiType, apiFlows, planFlows);
        this.checkOverlappingPaths(apiType, flowsWithPathParam);
    }

    private Stream<Flow> filterFlowsWithPathParam(ApiType apiType, Stream<Flow> apiFlows, Stream<Flow> planFlows) {
        return Stream.concat(apiFlows, planFlows).filter(AbstractFlow::isEnabled).filter(flow -> FlowValidationDomainService.containsPathParam(apiType, flow));
    }

    private void checkOverlappingPaths(ApiType apiType, Stream<Flow> flows) {
        List<String> uniquePaths = flows.map(flow -> FlowValidationDomainService.extractPath(apiType, flow)).map(this::normalizePath).filter(path -> !path.isEmpty()).distinct().toList();
        HashMap<String, Set> overlappingPaths = new HashMap<String, Set>();
        int pathCount = uniquePaths.size();
        for (int i = 0; i < pathCount; ++i) {
            String path1 = uniquePaths.get(i);
            String[] segments1 = this.splitPathSegments(path1);
            for (int j = i + 1; j < pathCount; ++j) {
                String path2 = uniquePaths.get(j);
                String[] segments2 = this.splitPathSegments(path2);
                if (segments1.length != segments2.length || !this.arePathsAmbiguous(segments1, segments2)) continue;
                String key = this.buildAmbiguitySignature(segments1);
                Set paths = overlappingPaths.computeIfAbsent(key, k -> new HashSet());
                paths.add(path1);
                paths.add(path2);
            }
        }
        if (!overlappingPaths.isEmpty()) {
            Map<String, String> payload = overlappingPaths.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                ArrayList sortedPaths = new ArrayList((Collection)entry.getValue());
                sortedPaths.sort(String::compareTo);
                return ((Object)sortedPaths).toString();
            }));
            throw new ValidationDomainException("Invalid path parameters", payload);
        }
    }

    private boolean arePathsAmbiguous(String[] segments1, String[] segments2) {
        for (int i = 0; i < segments1.length; ++i) {
            boolean isParam1 = segments1[i].startsWith(PATH_PARAM_PREFIX);
            boolean isParam2 = segments2[i].startsWith(PATH_PARAM_PREFIX);
            if (isParam1 && isParam2 || !isParam1 && !isParam2 && segments1[i].equals(segments2[i])) continue;
            return false;
        }
        return true;
    }

    private String normalizePath(String raw) {
        if (raw == null) {
            return "";
        }
        Object p = raw.trim();
        if (((String)p).isEmpty()) {
            return "";
        }
        if (((String)(p = ((String)p).replaceAll("/{2,}", PATH_SEPARATOR))).length() > 1 && ((String)p).endsWith(PATH_SEPARATOR)) {
            p = ((String)p).substring(0, ((String)p).length() - 1);
        }
        if (!((String)p).startsWith(PATH_SEPARATOR)) {
            p = PATH_SEPARATOR + (String)p;
        }
        return p;
    }

    private String[] splitPathSegments(String path) {
        return (String[])Arrays.stream(SEPARATOR_SPLITTER.split(path)).filter(s -> !s.isEmpty()).toArray(String[]::new);
    }

    private String buildAmbiguitySignature(String[] segments) {
        return PATH_SEPARATOR + Arrays.stream(segments).map(s -> s.startsWith(PATH_PARAM_PREFIX) ? PATH_PARAM_PREFIX : s).collect(Collectors.joining(PATH_SEPARATOR));
    }

    private static Boolean containsPathParam(ApiType apiType, Flow flow) {
        String path = FlowValidationDomainService.extractPath(apiType, flow);
        return PARAM_PATTERN.asPredicate().test(path);
    }

    private static String extractPath(ApiType apiType, Flow flow) {
        return PATH_EXTRACTOR.get(apiType).apply(flow).orElse("");
    }
}

