/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.domain_service.OAIDomainService;
import io.gravitee.apim.core.api.domain_service.import_definition.ImportDefinitionCreateDomainService;
import io.gravitee.apim.core.api.model.ApiWithFlows;
import io.gravitee.apim.core.api.model.import_definition.ImportDefinition;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import lombok.Generated;

@UseCase
public class OAIToImportApiUseCase {
    protected static final String DEFAULT_IMPORT_PAGE_NAME = "Swagger";
    private final OAIDomainService oaiDomainService;
    private final ImportDefinitionCreateDomainService importDefinitionCreateDomainService;

    public OAIToImportApiUseCase(OAIDomainService oaiDomainService, ImportDefinitionCreateDomainService importDefinitionCreateDomainService) {
        this.oaiDomainService = oaiDomainService;
        this.importDefinitionCreateDomainService = importDefinitionCreateDomainService;
    }

    public Output execute(Input input) {
        String environmentId;
        String organizationId = input.auditInfo.organizationId();
        ImportDefinition importDefinition = this.oaiDomainService.convert(organizationId, environmentId = input.auditInfo.environmentId(), input.importSwaggerDescriptor, input.withDocumentation(), input.withOASValidationPolicy());
        if (importDefinition != null) {
            ApiWithFlows apiWithFlows = this.importDefinitionCreateDomainService.create(input.auditInfo, importDefinition);
            return new Output(apiWithFlows);
        }
        return null;
    }

    public record Input(ImportSwaggerDescriptorEntity importSwaggerDescriptor, boolean withDocumentation, boolean withOASValidationPolicy, AuditInfo auditInfo) {
        Input(ImportSwaggerDescriptorEntity importSwaggerDescriptor, AuditInfo auditInfo) {
            this(importSwaggerDescriptor, false, false, auditInfo);
        }

        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private ImportSwaggerDescriptorEntity importSwaggerDescriptor;
            @Generated
            private boolean withDocumentation;
            @Generated
            private boolean withOASValidationPolicy;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder importSwaggerDescriptor(ImportSwaggerDescriptorEntity importSwaggerDescriptor) {
                this.importSwaggerDescriptor = importSwaggerDescriptor;
                return this;
            }

            @Generated
            public InputBuilder withDocumentation(boolean withDocumentation) {
                this.withDocumentation = withDocumentation;
                return this;
            }

            @Generated
            public InputBuilder withOASValidationPolicy(boolean withOASValidationPolicy) {
                this.withOASValidationPolicy = withOASValidationPolicy;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.importSwaggerDescriptor, this.withDocumentation, this.withOASValidationPolicy, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "OAIToImportApiUseCase.Input.InputBuilder(importSwaggerDescriptor=" + String.valueOf(this.importSwaggerDescriptor) + ", withDocumentation=" + this.withDocumentation + ", withOASValidationPolicy=" + this.withOASValidationPolicy + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
            }
        }
    }

    public record Output(ApiWithFlows apiWithFlows) {
    }
}

